/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class PayLoyaltyCost
extends CostImpl {
    private int amount;

    public PayLoyaltyCost(int amount) {
        this.setAmount(amount);
    }

    public PayLoyaltyCost(PayLoyaltyCost cost) {
        super(cost);
        this.amount = cost.amount;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Permanent planeswalker = game.getPermanent(source.getSourceId());
        if (planeswalker == null) {
            return false;
        }
        int loyaltyCost = this.amount;
        if (ability instanceof LoyaltyAbility) {
            LoyaltyAbility copiedAbility = ((LoyaltyAbility)ability).copy();
            copiedAbility.adjustX(game);
            game.getContinuousEffects().costModification(copiedAbility, game);
            loyaltyCost = 0;
            for (Cost cost : copiedAbility.getCosts()) {
                if (!(cost instanceof PayLoyaltyCost)) continue;
                loyaltyCost += ((PayLoyaltyCost)cost).getAmount();
            }
        }
        return planeswalker.getCounters(game).getCount(CounterType.LOYALTY) + loyaltyCost >= 0 && planeswalker.canLoyaltyBeUsed(game);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Permanent planeswalker = game.getPermanent(source.getSourceId());
        if (planeswalker != null && planeswalker.getCounters(game).getCount(CounterType.LOYALTY) + this.amount >= 0 && planeswalker.canLoyaltyBeUsed(game)) {
            if (this.amount > 0) {
                planeswalker.addCounters(CounterType.LOYALTY.createInstance(this.amount), source.getControllerId(), ability, game, false);
            } else if (this.amount < 0) {
                planeswalker.removeCounters(CounterType.LOYALTY.getName(), Math.abs(this.amount), source, game);
            }
            planeswalker.addLoyaltyUsed();
            this.paid = true;
        }
        return this.paid;
    }

    @Override
    public PayLoyaltyCost copy() {
        return new PayLoyaltyCost(this);
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.text = Integer.toString(this.amount);
        if (this.amount > 0) {
            this.text = '+' + this.text;
        }
    }
}

