/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.PayLoyaltyCost;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class PayVariableLoyaltyCost
extends VariableCostImpl {
    private int costModification = 0;

    public PayVariableLoyaltyCost() {
        super(VariableCostType.NORMAL, "loyality counters to remove");
        this.text = "-X";
    }

    protected PayVariableLoyaltyCost(PayVariableLoyaltyCost cost) {
        super(cost);
        this.costModification = cost.costModification;
    }

    @Override
    public PayVariableLoyaltyCost copy() {
        return new PayVariableLoyaltyCost(this);
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Permanent planeswalker = game.getPermanent(source.getSourceId());
        return planeswalker != null && planeswalker.canLoyaltyBeUsed(game);
    }

    @Override
    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        return new PayLoyaltyCost(-xValue);
    }

    @Override
    public int getMaxValue(Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return 0;
        }
        int maxValue = permanent.getCounters(game).getCount(CounterType.LOYALTY);
        if (source instanceof LoyaltyAbility) {
            LoyaltyAbility copiedAbility = ((LoyaltyAbility)source).copy();
            copiedAbility.adjustX(game);
            game.getContinuousEffects().costModification(copiedAbility, game);
            for (Cost cost : copiedAbility.getCosts()) {
                if (!(cost instanceof PayVariableLoyaltyCost)) continue;
                maxValue += ((PayVariableLoyaltyCost)cost).getCostModification();
            }
        }
        return Math.max(0, maxValue);
    }

    public int getCostModification() {
        return this.costModification;
    }

    public void setCostModification(int costModification) {
        this.costModification = costModification;
    }
}

