/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.common.TargetControlledPermanent;

public class PutCountersTargetCost
extends CostImpl {
    private final Counter counter;

    public PutCountersTargetCost(Counter counter) {
        this(counter, new TargetControlledCreaturePermanent());
    }

    public PutCountersTargetCost(Counter counter, TargetControlledPermanent target) {
        this.counter = counter.copy();
        target.withNotTarget(true);
        this.addTarget(target);
        this.text = "put " + counter.getDescription() + " on " + target.getDescription();
    }

    public PutCountersTargetCost(PutCountersTargetCost cost) {
        super(cost);
        this.counter = cost.counter.copy();
    }

    @Override
    public PutCountersTargetCost copy() {
        return new PutCountersTargetCost(this);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null || !this.getTargets().choose(Outcome.Exile, controllerId, source.getSourceId(), source, game)) {
            return this.paid;
        }
        for (UUID targetId : ((Target)this.getTargets().get(0)).getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) {
                return false;
            }
            this.paid |= permanent.addCounters(this.counter, controllerId, ability, game);
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }
}

