/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.CardsImpl;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class PutSourceOnBottomOwnerLibraryCost
extends CostImpl {
    public PutSourceOnBottomOwnerLibraryCost() {
        this.text = this.setText();
    }

    public PutSourceOnBottomOwnerLibraryCost(PutSourceOnBottomOwnerLibraryCost cost) {
        super(cost);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(controllerId);
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (player != null && sourcePermanent != null) {
            this.paid = true;
            player.putCardsOnBottomOfLibrary(new CardsImpl(sourcePermanent), game, ability, false);
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return game.getPermanentOrLKIBattlefield(source.getSourceId()) != null;
    }

    @Override
    public PutSourceOnBottomOwnerLibraryCost copy() {
        return new PutSourceOnBottomOwnerLibraryCost(this);
    }

    private String setText() {
        return "Put {this} on the bottom of its owner's library";
    }
}

