/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;
import mage.util.CardUtil;

public class ReturnToHandChosenControlledPermanentCost
extends CostImpl {
    private final List<Permanent> permanents = new ArrayList<Permanent>();

    public ReturnToHandChosenControlledPermanentCost(TargetControlledPermanent target) {
        target.withNotTarget(true);
        this.addTarget(target);
        this.text = target.getMaxNumberOfTargets() > 1 && target.getMaxNumberOfTargets() == target.getMinNumberOfTargets() ? "return " + CardUtil.numberToText(target.getMaxNumberOfTargets()) + ' ' + target.getTargetName() + (target.getTargetName().endsWith(" you control") ? "" : " you control") + " to their owner's hand" : "return " + CardUtil.addArticle(target.getTargetName()) + (target.getTargetName().endsWith(" you control") ? "" : " you control") + " to its owner's hand";
    }

    protected ReturnToHandChosenControlledPermanentCost(ReturnToHandChosenControlledPermanentCost cost) {
        super(cost);
        for (Permanent permanent : cost.permanents) {
            this.permanents.add(permanent.copy());
        }
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null && this.getTargets().choose(Outcome.ReturnToHand, controllerId, source.getSourceId(), source, game)) {
            HashSet<Permanent> permanentsToReturn = new HashSet<Permanent>();
            for (UUID targetId : ((Target)this.getTargets().get(0)).getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) {
                    return false;
                }
                this.addReturnTarget(game, permanent);
                permanentsToReturn.add(permanent);
            }
            controller.moveCards(permanentsToReturn, Zone.HAND, ability, game);
            this.paid = true;
        }
        return this.paid;
    }

    protected void addReturnTarget(Game game, Permanent permanent) {
        this.permanents.add(permanent.copy());
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }

    @Override
    public ReturnToHandChosenControlledPermanentCost copy() {
        return new ReturnToHandChosenControlledPermanentCost(this);
    }

    public List<Permanent> getPermanents() {
        return this.permanents;
    }
}

