/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.effects.common.ChooseSecretOpponentEffect;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class RevealSecretOpponentCost
extends CostImpl {
    public RevealSecretOpponentCost() {
        this.text = "Reveal the player you chose";
    }

    protected RevealSecretOpponentCost(RevealSecretOpponentCost cost) {
        super(cost);
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return controllerId != null && controllerId.equals(ChooseSecretOpponentEffect.getSecretOwner(source, game)) && ChooseSecretOpponentEffect.getChosenPlayer(source, game) != null;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (controllerId == null || !controllerId.equals(ChooseSecretOpponentEffect.getSecretOwner(source, game))) {
            return false;
        }
        UUID opponentId = ChooseSecretOpponentEffect.getChosenPlayer(source, game);
        if (opponentId == null) {
            return this.paid;
        }
        ChooseSecretOpponentEffect.setSecretOwner(null, source, game);
        Player controller = game.getPlayer(controllerId);
        Player opponent = game.getPlayer(opponentId);
        MageObject sourceObject = game.getObject(source);
        if (controller != null && opponent != null && sourceObject != null) {
            if (sourceObject instanceof Permanent) {
                ((Permanent)sourceObject).addInfo("_secOpp", null, game);
            }
            game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " reveals the secretly chosen opponent " + opponent.getLogName());
        }
        this.paid = true;
        return this.paid;
    }

    @Override
    public RevealSecretOpponentCost copy() {
        return new RevealSecretOpponentCost(this);
    }
}

