/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

public class RevealTargetFromHandCost
extends CostImpl {
    public int manaValues = 0;
    protected int numberCardsRevealed = 0;
    protected List<Card> revealedCards;
    private boolean allowNoReveal;

    public RevealTargetFromHandCost(TargetCardInHand target) {
        this.addTarget(target);
        this.allowNoReveal = target.getMinNumberOfTargets() == 0;
        this.text = "reveal " + target.getDescription();
        this.revealedCards = new ArrayList<Card>();
    }

    protected RevealTargetFromHandCost(RevealTargetFromHandCost cost) {
        super(cost);
        this.manaValues = cost.manaValues;
        this.numberCardsRevealed = cost.numberCardsRevealed;
        this.revealedCards = new ArrayList<Card>(cost.revealedCards);
        this.allowNoReveal = cost.allowNoReveal;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (this.getTargets().choose(Outcome.Benefit, controllerId, source.getSourceId(), source, game)) {
            this.manaValues = 0;
            this.numberCardsRevealed = 0;
            Player player = game.getPlayer(controllerId);
            CardsImpl cards = new CardsImpl();
            for (UUID targetId : ((Target)this.getTargets().get(0)).getTargets()) {
                Card card = player.getHand().get(targetId, game);
                if (card == null) continue;
                this.manaValues += card.getManaValue();
                ++this.numberCardsRevealed;
                cards.add(card);
                this.revealedCards.add(card);
            }
            if (this.numberCardsRevealed > 0) {
                MageObject baseObject = game.getBaseObject(source.getSourceId());
                player.revealCards(baseObject == null ? "card cost" : baseObject.getIdName(), (Cards)cards, game);
            }
            if (((Target)this.getTargets().get(0)).getMinNumberOfTargets() <= this.numberCardsRevealed) {
                this.paid = true;
                return this.paid;
            }
        } else if (this.allowNoReveal) {
            this.paid = true;
            return this.paid;
        }
        this.paid = false;
        return this.paid;
    }

    public int getConvertedCosts() {
        return this.manaValues;
    }

    public int getNumberRevealedCards() {
        return this.numberCardsRevealed;
    }

    public List<Card> getRevealedCards() {
        return this.revealedCards;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.allowNoReveal || this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }

    @Override
    public RevealTargetFromHandCost copy() {
        return new RevealTargetFromHandCost(this);
    }
}

