/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.mana;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.AbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.VariableCost;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.costs.mana.ColoredManaCost;
import mage.abilities.costs.mana.ColorlessHybridManaCost;
import mage.abilities.costs.mana.ColorlessManaCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.HybridManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostImpl;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.MonoHybridManaCost;
import mage.abilities.costs.mana.SnowManaCost;
import mage.abilities.costs.mana.VariableManaCost;
import mage.abilities.mana.ManaOptions;
import mage.constants.ColoredManaSymbol;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.filter.Filter;
import mage.game.Game;
import mage.players.ManaPool;
import mage.players.Player;
import mage.target.Targets;
import mage.util.CardUtil;
import mage.util.ManaUtil;

public class ManaCostsImpl<T extends ManaCost>
extends ArrayList<T>
implements ManaCosts<T> {
    protected final UUID id;
    protected String text = null;
    protected boolean phyrexian = false;
    private int phyrexianPaid = 0;
    private static final Map<String, ManaCosts> costsCache = new ConcurrentHashMap<String, ManaCosts>();

    public ManaCostsImpl() {
        this.id = UUID.randomUUID();
    }

    public ManaCostsImpl(String mana) {
        this.id = UUID.randomUUID();
        this.load(mana);
    }

    protected ManaCostsImpl(ManaCostsImpl<T> costs) {
        this.id = costs.id;
        this.text = costs.text;
        this.ensureCapacity(costs.size());
        for (ManaCost cost : costs) {
            this.add(cost.copy());
        }
        this.phyrexian = costs.phyrexian;
        this.phyrexianPaid = costs.phyrexianPaid;
    }

    @Override
    public final boolean add(ManaCost cost) {
        if (cost instanceof ManaCosts) {
            for (ManaCost manaCost : (ManaCosts)cost) {
                super.add(manaCost);
            }
            return true;
        }
        return super.add(cost);
    }

    @Override
    public int manaValue() {
        int total = 0;
        for (ManaCost cost : this) {
            total += cost.manaValue();
        }
        return total;
    }

    @Override
    public Mana getMana() {
        Mana mana = new Mana();
        for (ManaCost cost : this) {
            mana.add(cost.getMana());
        }
        return mana;
    }

    @Override
    public List<Mana> getManaOptions() {
        ArrayList<Mana> manaVariants = new ArrayList<Mana>();
        for (ManaCost cost : this) {
            manaVariants.addAll(cost.getManaOptions());
        }
        return manaVariants;
    }

    @Override
    public Mana getPayment() {
        Mana manaTotal = new Mana();
        for (ManaCost cost : this) {
            manaTotal.add(cost.getPayment());
        }
        return manaTotal;
    }

    @Override
    public Mana getUsedManaToPay() {
        Mana manaTotal = new Mana();
        for (ManaCost cost : this) {
            manaTotal.add(cost.getUsedManaToPay());
        }
        return manaTotal;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana) {
        return this.pay(ability, game, source, controllerId, noMana, this);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID playerId, boolean noMana, Cost costToPay) {
        if (this.isEmpty() || noMana) {
            this.setPaid();
            return true;
        }
        Player player = game.getPlayer(playerId);
        if (player == null) {
            return false;
        }
        AbilityImpl.handlePhyrexianLikeEffects(game, source, ability, this);
        if (!player.getManaPool().isForcedToPay()) {
            this.assignPayment(game, ability, player.getManaPool(), costToPay != null ? costToPay : this);
        }
        game.getState().getSpecialActions().removeManaActions();
        while (player.canRespond() && !this.isPaid()) {
            String promptText;
            ManaCost unpaid = this.getUnpaid();
            if (!player.playMana(ability, unpaid, promptText = ManaUtil.addSpecialManaPayAbilities(ability, game, unpaid), game)) {
                return false;
            }
            this.assignPayment(game, ability, player.getManaPool(), costToPay != null ? costToPay : this);
            game.getState().getSpecialActions().removeManaActions();
        }
        return this.isPaid();
    }

    @Override
    public boolean payOrRollback(Ability ability, Game game, Ability source, UUID payingPlayerId) {
        Player payingPlayer = game.getPlayer(payingPlayerId);
        if (payingPlayer != null) {
            int bookmark = game.bookmarkState();
            this.handlePhyrexianManaCosts(ability, payingPlayer, source, game);
            if (this.pay(ability, game, source, payingPlayerId, false, null)) {
                game.removeBookmark(bookmark);
                return true;
            }
            payingPlayer.restoreState(bookmark, ability.getRule(), game);
        }
        return false;
    }

    private void handlePhyrexianManaCosts(Ability abilityToPay, Player payingPlayer, Ability source, Game game) {
        if (this.isEmpty()) {
            return;
        }
        Iterator manaCostIterator = this.iterator();
        CostsImpl tempCosts = new CostsImpl();
        while (manaCostIterator.hasNext()) {
            PayLifeCost payLifeCost;
            ManaCost manaCost = (ManaCost)manaCostIterator.next();
            if (!manaCost.isPhyrexian() || !(payLifeCost = new PayLifeCost(2)).canPay(abilityToPay, source, payingPlayer.getId(), game) || !payingPlayer.chooseUse(Outcome.LoseLife, "Pay 2 life instead of " + manaCost.getText().replace("/P", "") + '?', source, game)) continue;
            manaCostIterator.remove();
            tempCosts.add(payLifeCost);
            this.incrPhyrexianPaid();
        }
        tempCosts.pay(source, game, source, payingPlayer.getId(), false, null);
    }

    @Override
    public ManaCosts<T> getUnpaid() {
        ManaCostsImpl<T> unpaid = new ManaCostsImpl<T>();
        for (ManaCost cost : this) {
            if (cost instanceof VariableManaCost || cost.isPaid()) continue;
            unpaid.add(cost.getUnpaid());
        }
        return unpaid;
    }

    @Override
    public ManaCosts<T> getUnpaidVariableCosts() {
        ManaCostsImpl<T> unpaid = new ManaCostsImpl<T>();
        for (ManaCost cost : this) {
            if (!(cost instanceof VariableManaCost) || cost.isPaid()) continue;
            unpaid.add(cost.getUnpaid());
        }
        return unpaid;
    }

    @Override
    public List<VariableCost> getVariableCosts() {
        ArrayList<VariableCost> variableCosts = new ArrayList<VariableCost>();
        for (ManaCost cost : this) {
            if (!(cost instanceof VariableCost)) continue;
            variableCosts.add((VariableCost)((Object)cost));
        }
        return variableCosts;
    }

    @Override
    public boolean containsX() {
        return !this.getVariableCosts().isEmpty();
    }

    @Override
    public void setX(int xValue, int xPay) {
        List<VariableCost> variableCosts = this.getVariableCosts();
        if (!variableCosts.isEmpty()) {
            variableCosts.get(0).setAmount(xValue, xPay, false);
        }
    }

    @Override
    public void setPayment(Mana mana) {
    }

    private boolean canPayColoredManaFromPool(ManaType needColor, ManaCost cost, ManaType canUseManaType, ManaPool pool) {
        if (canUseManaType == null || canUseManaType.equals((Object)needColor)) {
            return cost.containsColor(CardUtil.manaTypeToColoredManaSymbol(needColor)) && (pool.getColoredAmount(needColor) > 0 || pool.conditionalManaHasManaType(needColor));
        }
        return false;
    }

    @Override
    public void assignPayment(Game game, Ability ability, ManaPool pool, Cost costToPay) {
        ManaType canUseManaType;
        if (pool.isAutoPayment()) {
            canUseManaType = null;
        } else {
            canUseManaType = pool.getUnlockedManaType();
            if (canUseManaType == null) {
                return;
            }
        }
        ManaCosts referenceCosts = null;
        if (pool.isForcedToPay()) {
            referenceCosts = this.copy();
        }
        for (ManaCost cost : this) {
            if (cost.isPaid() || !(cost instanceof ColorlessManaCost)) continue;
            cost.assignPayment(game, ability, pool, costToPay);
            if (!pool.isEmpty()) continue;
            return;
        }
        for (ManaCost cost : this) {
            if (cost.isPaid() || !(cost instanceof ColoredManaCost)) continue;
            cost.assignPayment(game, ability, pool, costToPay);
            if (!pool.isEmpty()) continue;
            return;
        }
        for (ManaCost cost : this) {
            if (cost.isPaid() || !(cost instanceof HybridManaCost)) continue;
            cost.assignPayment(game, ability, pool, costToPay);
            if (!pool.isEmpty()) continue;
            return;
        }
        for (ManaCost cost : this) {
            if (cost.isPaid() || !(cost instanceof ColorlessHybridManaCost)) continue;
            cost.assignPayment(game, ability, pool, costToPay);
            if (!pool.isEmpty()) continue;
            return;
        }
        for (ManaCost cost : this) {
            if (cost.isPaid() || !(cost instanceof MonoHybridManaCost) || !this.canPayColoredManaFromPool(ManaType.WHITE, cost, canUseManaType, pool) && !this.canPayColoredManaFromPool(ManaType.BLACK, cost, canUseManaType, pool) && !this.canPayColoredManaFromPool(ManaType.RED, cost, canUseManaType, pool) && !this.canPayColoredManaFromPool(ManaType.GREEN, cost, canUseManaType, pool) && !this.canPayColoredManaFromPool(ManaType.BLUE, cost, canUseManaType, pool)) continue;
            cost.assignPayment(game, ability, pool, costToPay);
            if (!pool.isEmpty() || !pool.getConditionalMana().isEmpty()) continue;
            return;
        }
        for (ManaCost cost : this) {
            if (cost.isPaid() || !(cost instanceof MonoHybridManaCost)) continue;
            cost.assignPayment(game, ability, pool, costToPay);
            if (!pool.isEmpty()) continue;
            return;
        }
        for (ManaCost cost : this) {
            if (cost.isPaid() || !(cost instanceof SnowManaCost)) continue;
            cost.assignPayment(game, ability, pool, costToPay);
            if (!pool.isEmpty()) continue;
            return;
        }
        for (ManaCost cost : this) {
            if (cost.isPaid() || !(cost instanceof GenericManaCost)) continue;
            cost.assignPayment(game, ability, pool, costToPay);
            if (!pool.isEmpty()) continue;
            return;
        }
        for (ManaCost cost : this) {
            if (cost.isPaid() || !(cost instanceof VariableManaCost)) continue;
            cost.assignPayment(game, ability, pool, costToPay);
        }
        pool.lockManaType();
        if (canUseManaType == null) {
            this.handleForcedToPayOnlyForCurrentPayment(game, pool, referenceCosts);
        }
    }

    private void handleForcedToPayOnlyForCurrentPayment(Game game, ManaPool pool, ManaCosts referenceCosts) {
        UUID playerId;
        Player player;
        if (pool.isForcedToPay() && referenceCosts != null && this.getText().equals(referenceCosts.getText()) && (player = game.getPlayer(playerId = pool.getPlayerId())) != null) {
            game.undo(playerId);
            this.clearPaid();
            int amount = 0;
            List<VariableCost> variableCosts = this.getVariableCosts();
            if (!variableCosts.isEmpty()) {
                amount = variableCosts.get(0).getAmount();
            }
            this.setX(amount, amount);
            player.getManaPool().restoreMana(pool.getPoolBookmark());
            game.bookmarkState();
        }
    }

    public void forceManaRollback(Game game, ManaPool pool) {
        this.handleForcedToPayOnlyForCurrentPayment(game, pool, this);
    }

    @Override
    public final void load(String mana, boolean extractMonoHybridGenericValue) {
        this.clear();
        if (mana == null || mana.isEmpty()) {
            return;
        }
        if (!mana.startsWith("{") || !mana.endsWith("}")) {
            throw new IllegalArgumentException("mana costs should start and end with braces");
        }
        if (!extractMonoHybridGenericValue && costsCache.containsKey(mana)) {
            ManaCosts savedCosts = costsCache.get(mana);
            for (ManaCost cost : savedCosts) {
                this.add(cost.copy());
            }
            return;
        }
        String[] symbols = mana.split("^\\{|}\\{|}$");
        int modifierForX = 0;
        for (String symbol : symbols) {
            if (symbol.isEmpty()) continue;
            if (symbol.length() == 1 || this.isNumeric(symbol)) {
                if (Character.isDigit(symbol.charAt(0))) {
                    this.add(new GenericManaCost(Integer.parseInt(symbol)));
                    continue;
                }
                if (symbol.equals("S")) {
                    this.add(new SnowManaCost());
                    continue;
                }
                if (symbol.equals("C")) {
                    this.add(new ColorlessManaCost(1));
                    continue;
                }
                if (!symbol.equals("X")) {
                    this.add(new ColoredManaCost(ColoredManaSymbol.lookup(symbol.charAt(0))));
                    continue;
                }
                if (modifierForX != 0) continue;
                for (String s : symbols) {
                    if (!s.equals("X")) continue;
                    ++modifierForX;
                }
                this.add(new VariableManaCost(VariableCostType.NORMAL, modifierForX));
                continue;
            }
            if (Character.isDigit(symbol.charAt(0))) {
                MonoHybridManaCost cost = extractMonoHybridGenericValue ? new MonoHybridManaCost(ColoredManaSymbol.lookup(symbol.charAt(2)), Integer.parseInt(symbol.substring(0, 1))) : new MonoHybridManaCost(ColoredManaSymbol.lookup(symbol.charAt(2)));
                this.add(cost);
                continue;
            }
            boolean phyrexian = symbol.contains("/P");
            String without = symbol.replace("/P", "");
            ManaCostImpl cost = without.length() == 1 ? new ColoredManaCost(ColoredManaSymbol.lookup(without.charAt(0))) : (without.charAt(0) == 'C' ? new ColorlessHybridManaCost(ColoredManaSymbol.lookup(without.charAt(2))) : new HybridManaCost(ColoredManaSymbol.lookup(without.charAt(0)), ColoredManaSymbol.lookup(without.charAt(2))));
            cost.setPhyrexian(phyrexian);
            this.add(cost);
        }
        if (!extractMonoHybridGenericValue) {
            costsCache.put(mana, this.copy());
        }
    }

    private boolean isNumeric(String symbol) {
        try {
            Integer.parseInt(symbol);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public ManaCostsImpl<T> setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sbText = new StringBuilder();
        for (ManaCost cost : this) {
            sbText.append(cost.getText());
        }
        return sbText.toString();
    }

    @Override
    public ManaOptions getOptions() {
        return this.getOptions(true);
    }

    @Override
    public ManaOptions getOptions(boolean canPayLifeCost) {
        ManaOptions options = new ManaOptions();
        for (ManaCost cost : this) {
            options.addMana(cost.getOptions(canPayLifeCost));
        }
        return options;
    }

    @Override
    public boolean testPay(Mana testMana) {
        for (ManaCost cost : this) {
            if (!cost.testPay(testMana)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        for (ManaCost cost : this) {
            if (cost.canPay(ability, source, controllerId, game)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPaid() {
        for (ManaCost cost : this) {
            if (cost instanceof VariableManaCost || cost.isPaid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearPaid() {
        for (ManaCost cost : this) {
            cost.clearPaid();
        }
    }

    @Override
    public void setPaid() {
        for (ManaCost cost : this) {
            cost.setPaid();
        }
    }

    @Override
    public Targets getTargets() {
        Targets res = new Targets();
        for (ManaCost cost : this) {
            res.addAll(cost.getTargets());
        }
        return res.withReadOnly();
    }

    @Override
    public ManaCostsImpl<T> copy() {
        return new ManaCostsImpl<T>(this);
    }

    @Override
    public boolean isPhyrexian() {
        return this.phyrexian;
    }

    @Override
    public void setPhyrexian(boolean phyrexian) {
        this.phyrexian = phyrexian;
        for (ManaCost cost : this) {
            cost.setPhyrexian(phyrexian);
        }
    }

    @Override
    public void incrPhyrexianPaid() {
        ++this.phyrexianPaid;
    }

    @Override
    public int getPhyrexianPaid() {
        return this.phyrexianPaid;
    }

    @Override
    public Filter getSourceFilter() {
        for (ManaCost cost : this) {
            if (cost.getSourceFilter() == null) continue;
            return cost.getSourceFilter();
        }
        return null;
    }

    @Override
    public void setSourceFilter(Filter filter) {
        for (ManaCost cost : this) {
            cost.setSourceFilter(filter);
        }
    }

    @Override
    public boolean containsColor(ColoredManaSymbol coloredManaSymbol) {
        for (ManaCost manaCost : this) {
            if (!manaCost.containsColor(coloredManaSymbol)) continue;
            return true;
        }
        return false;
    }
}

