/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.mana;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostImpl;
import mage.constants.ColoredManaSymbol;
import mage.game.Game;
import mage.players.ManaPool;

public class MonoHybridManaCost
extends ManaCostImpl {
    private final ColoredManaSymbol manaColor;
    private int manaGeneric;

    public MonoHybridManaCost(ColoredManaSymbol manaColor) {
        this(manaColor, 2);
    }

    public MonoHybridManaCost(ColoredManaSymbol manaColor, int genericAmount) {
        this.manaColor = manaColor;
        this.manaGeneric = genericAmount;
        this.cost = new Mana(manaColor);
        this.cost.add(Mana.GenericMana(genericAmount));
        this.addColoredOption(manaColor);
        this.options.add(Mana.GenericMana(genericAmount));
    }

    public MonoHybridManaCost(MonoHybridManaCost manaCost) {
        super(manaCost);
        this.manaColor = manaCost.manaColor;
        this.manaGeneric = manaCost.manaGeneric;
    }

    @Override
    public int manaValue() {
        return Math.max(this.manaGeneric, 1);
    }

    @Override
    public boolean isPaid() {
        if (this.paid || this.isColoredPaid(this.manaColor)) {
            return true;
        }
        return this.isColorlessPaid(this.manaGeneric);
    }

    @Override
    public void assignPayment(Game game, Ability ability, ManaPool pool, Cost costToPay) {
        if (!this.assignColored(ability, game, pool, this.manaColor, costToPay)) {
            this.assignGeneric(ability, game, pool, this.manaGeneric, null, costToPay);
        }
    }

    @Override
    public String getText() {
        return "{" + this.manaGeneric + "/" + this.manaColor.toString() + '}';
    }

    @Override
    public MonoHybridManaCost getUnpaid() {
        return this;
    }

    @Override
    public boolean testPay(Mana testMana) {
        switch (this.manaColor) {
            case B: {
                if (testMana.getBlack() > 0) {
                    return true;
                }
            }
            case U: {
                if (testMana.getBlue() > 0) {
                    return true;
                }
            }
            case R: {
                if (testMana.getRed() > 0) {
                    return true;
                }
            }
            case W: {
                if (testMana.getWhite() > 0) {
                    return true;
                }
            }
            case G: {
                if (testMana.getGreen() <= 0) break;
                return true;
            }
        }
        return testMana.count() > 0;
    }

    @Override
    public MonoHybridManaCost copy() {
        return new MonoHybridManaCost(this);
    }

    @Override
    public boolean containsColor(ColoredManaSymbol coloredManaSymbol) {
        return this.manaColor == coloredManaSymbol;
    }

    public ColoredManaSymbol getManaColor() {
        return this.manaColor;
    }

    @Override
    public List<Mana> getManaOptions() {
        ArrayList<Mana> manaList = new ArrayList<Mana>();
        manaList.add(new Mana(this.manaColor));
        manaList.add(Mana.GenericMana(this.manaGeneric));
        return manaList;
    }
}

