/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.mana;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.MinMaxVariableCost;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.mana.ManaCostImpl;
import mage.abilities.mana.ManaOptions;
import mage.constants.ColoredManaSymbol;
import mage.filter.FilterMana;
import mage.game.Game;
import mage.players.ManaPool;
import mage.util.CardUtil;

public class VariableManaCost
extends ManaCostImpl
implements MinMaxVariableCost {
    protected VariableCostType costType;
    protected int xInstancesCount;
    protected int xValue = 0;
    protected int xPay = 0;
    protected boolean wasAnnounced = false;
    protected FilterMana filter;
    protected int minX = 0;
    protected int maxX = Integer.MAX_VALUE;

    public VariableManaCost(VariableCostType costType) {
        this(costType, 1);
    }

    public VariableManaCost(VariableCostType costType, int xInstancesCount) {
        this.costType = costType;
        this.xInstancesCount = xInstancesCount;
        this.cost = new Mana();
        this.options.add(new Mana());
    }

    protected VariableManaCost(VariableManaCost manaCost) {
        super(manaCost);
        this.costType = manaCost.costType;
        this.xInstancesCount = manaCost.xInstancesCount;
        this.xValue = manaCost.xValue;
        this.xPay = manaCost.xPay;
        this.wasAnnounced = manaCost.wasAnnounced;
        if (manaCost.filter != null) {
            this.filter = manaCost.filter.copy();
        }
        this.minX = manaCost.minX;
        this.maxX = manaCost.maxX;
    }

    @Override
    public int manaValue() {
        return 0;
    }

    @Override
    public ManaOptions getOptions(boolean canPayLifeCost) {
        ManaOptions res = new ManaOptions();
        CardUtil.distributeValues(10, this.getMinX(), this.getMaxX()).forEach(value -> res.add(Mana.GenericMana(value)));
        return res;
    }

    @Override
    public void assignPayment(Game game, Ability ability, ManaPool pool, Cost costToPay) {
        this.assignGeneric(ability, game, pool, this.xPay, this.filter, costToPay);
    }

    @Override
    public String getText() {
        if (this.xInstancesCount > 1) {
            StringBuilder symbol = new StringBuilder(this.xInstancesCount);
            for (int i = 0; i < this.xInstancesCount; ++i) {
                symbol.append("{X}");
            }
            return symbol.toString();
        }
        return "{X}";
    }

    @Override
    public boolean isPaid() {
        if (!this.wasAnnounced) {
            return false;
        }
        if (this.paid) {
            return true;
        }
        return this.isColorlessPaid(this.xPay);
    }

    public boolean wasAnnounced() {
        return this.wasAnnounced;
    }

    @Override
    public VariableManaCost getUnpaid() {
        return this;
    }

    @Override
    public int getAmount() {
        return this.xValue;
    }

    @Override
    public void setAmount(int xValue, int xPay, boolean isPayed) {
        this.xValue = xValue;
        this.xPay = xPay;
        if (isPayed) {
            this.payment.setGeneric(xPay);
        }
        this.wasAnnounced = true;
    }

    @Override
    public boolean testPay(Mana testMana) {
        return true;
    }

    @Override
    public VariableManaCost copy() {
        return new VariableManaCost(this);
    }

    public int getXInstancesCount() {
        return this.xInstancesCount;
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public void setMinX(int minX) {
        this.minX = minX;
    }

    @Override
    public int getMaxX() {
        return this.maxX;
    }

    @Override
    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    @Override
    public boolean containsColor(ColoredManaSymbol coloredManaSymbol) {
        return false;
    }

    @Override
    public int announceXValue(Ability source, Game game) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String getActionText() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getMinValue(Ability source, Game game) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getMaxValue(Ability source, Game game) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public FilterMana getFilter() {
        return this.filter;
    }

    public void setFilter(FilterMana filter) {
        this.filter = filter;
    }

    @Override
    public VariableCostType getCostType() {
        return this.costType;
    }

    @Override
    public void setCostType(VariableCostType costType) {
        this.costType = costType;
    }
}

