/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.decorator;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.CostModificationEffect;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.Duration;
import mage.game.Game;

public class ConditionalCostModificationEffect
extends CostModificationEffectImpl {
    protected CostModificationEffect effect;
    protected CostModificationEffect otherwiseEffect;
    protected Condition condition;
    protected boolean conditionState;

    public ConditionalCostModificationEffect(CostModificationEffect effect, Condition condition, String text) {
        this(effect, condition, null, text);
    }

    public ConditionalCostModificationEffect(CostModificationEffect effect, Condition condition, CostModificationEffect otherwiseEffect, String text) {
        super(effect.getDuration(), effect.getOutcome(), effect.getModificationType());
        this.effect = effect;
        this.condition = condition;
        this.otherwiseEffect = otherwiseEffect;
        if (text != null) {
            this.setText(text);
        }
    }

    protected ConditionalCostModificationEffect(ConditionalCostModificationEffect effect) {
        super(effect);
        this.effect = (CostModificationEffect)effect.effect.copy();
        if (effect.otherwiseEffect != null) {
            this.otherwiseEffect = (CostModificationEffect)effect.otherwiseEffect.copy();
        }
        this.condition = effect.condition;
        this.conditionState = effect.conditionState;
    }

    @Override
    public boolean isDiscarded() {
        return this.effect.isDiscarded() || this.otherwiseEffect != null && this.otherwiseEffect.isDiscarded();
    }

    @Override
    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        this.conditionState = this.condition.apply(game, source);
        if (this.conditionState) {
            this.effect.setTargetPointer(this.getTargetPointer().copy());
            return this.effect.apply(game, source, abilityToModify);
        }
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            return this.otherwiseEffect.apply(game, source, abilityToModify);
        }
        if (!this.conditionState && this.effect.getDuration() == Duration.OneUse) {
            this.used = true;
        }
        if (!this.conditionState && this.effect.getDuration() == Duration.Custom) {
            this.discard();
        }
        return false;
    }

    @Override
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        this.conditionState = this.condition.apply(game, source);
        if (this.conditionState) {
            this.effect.setTargetPointer(this.getTargetPointer().copy());
            return this.effect.applies(abilityToModify, source, game);
        }
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            return this.otherwiseEffect.applies(abilityToModify, source, game);
        }
        return false;
    }

    @Override
    public ConditionalCostModificationEffect copy() {
        return new ConditionalCostModificationEffect(this);
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }
}

