/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

public enum AttachedPermanentToughnessCount implements DynamicValue
{
    instance;


    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Permanent attachmentPermanent = game.getPermanent(sourceAbility.getSourceId());
        if (attachmentPermanent == null) {
            attachmentPermanent = (Permanent)game.getLastKnownInformation(sourceAbility.getSourceId(), Zone.BATTLEFIELD, sourceAbility.getStackMomentSourceZCC());
        }
        if (attachmentPermanent == null || attachmentPermanent.getAttachedTo() == null) {
            return 0;
        }
        Permanent attached = effect.getValue("attachedTo") instanceof Permanent ? (Permanent)effect.getValue("attachedTo") : game.getPermanentOrLKIBattlefield(attachmentPermanent.getAttachedTo());
        if (attached != null && attached.getToughness().getValue() >= 0) {
            return attached.getToughness().getValue();
        }
        return 0;
    }

    @Override
    public AttachedPermanentToughnessCount copy() {
        return instance;
    }

    public String toString() {
        return "X";
    }

    @Override
    public String getMessage() {
        return "its toughness";
    }
}

