/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import java.util.function.ToIntFunction;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class GreatestAmongPermanentsValue
implements DynamicValue {
    public static final GreatestAmongPermanentsValue POWER_CONTROLLED_CREATURES = new GreatestAmongPermanentsValue(Quality.Power, StaticFilters.FILTER_CONTROLLED_CREATURES);
    public static final GreatestAmongPermanentsValue POWER_OTHER_CONTROLLED_CREATURES = new GreatestAmongPermanentsValue(Quality.Power, StaticFilters.FILTER_OTHER_CONTROLLED_CREATURES);
    public static final GreatestAmongPermanentsValue POWER_ALL_CREATURES = new GreatestAmongPermanentsValue(Quality.Power, new FilterCreaturePermanent("creatures on the battlefield"));
    public static final GreatestAmongPermanentsValue TOUGHNESS_CONTROLLED_CREATURES = new GreatestAmongPermanentsValue(Quality.Toughness, StaticFilters.FILTER_CONTROLLED_CREATURES);
    public static final GreatestAmongPermanentsValue TOUGHNESS_OTHER_CONTROLLED_CREATURES = new GreatestAmongPermanentsValue(Quality.Toughness, StaticFilters.FILTER_OTHER_CONTROLLED_CREATURES);
    public static final GreatestAmongPermanentsValue POWER_OR_TOUGHNESS_OTHER_CONTROLLED_CREATURES = new GreatestAmongPermanentsValue(Quality.PowerOrToughness, StaticFilters.FILTER_OTHER_CONTROLLED_CREATURES);
    public static final GreatestAmongPermanentsValue MANAVALUE_CONTROLLED_CREATURES = new GreatestAmongPermanentsValue(Quality.ManaValue, StaticFilters.FILTER_CONTROLLED_CREATURES);
    public static final GreatestAmongPermanentsValue MANAVALUE_OTHER_CONTROLLED_CREATURES = new GreatestAmongPermanentsValue(Quality.ManaValue, StaticFilters.FILTER_OTHER_CONTROLLED_CREATURES);
    public static final GreatestAmongPermanentsValue MANAVALUE_CONTROLLED_ARTIFACTS = new GreatestAmongPermanentsValue(Quality.ManaValue, StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACTS);
    public static final GreatestAmongPermanentsValue MANAVALUE_OTHER_CONTROLLED_ARTIFACTS = new GreatestAmongPermanentsValue(Quality.ManaValue, StaticFilters.FILTER_OTHER_CONTROLLED_ARTIFACTS);
    public static final GreatestAmongPermanentsValue MANAVALUE_CONTROLLED_PERMANENTS = new GreatestAmongPermanentsValue(Quality.ManaValue, StaticFilters.FILTER_CONTROLLED_PERMANENTS);
    public static final GreatestAmongPermanentsValue MANAVALUE_OTHER_CONTROLLED_PERMANENTS = new GreatestAmongPermanentsValue(Quality.ManaValue, StaticFilters.FILTER_OTHER_CONTROLLED_PERMANENTS);
    private final Quality quality;
    private final FilterPermanent filter;

    public GreatestAmongPermanentsValue(Quality quality, FilterPermanent filter) {
        this.filter = filter;
        this.quality = quality;
    }

    private GreatestAmongPermanentsValue(GreatestAmongPermanentsValue value) {
        this.filter = value.filter;
        this.quality = value.quality;
    }

    @Override
    public GreatestAmongPermanentsValue copy() {
        return new GreatestAmongPermanentsValue(this);
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return game.getBattlefield().getActivePermanents(this.filter, sourceAbility.getControllerId(), sourceAbility, game).stream().mapToInt(this.quality.mapToQuality).max().orElse(0);
    }

    @Override
    public String getMessage() {
        return "the greatest " + this.quality.text + " among " + this.filter.getMessage();
    }

    public String toString() {
        return "X";
    }

    public Hint getHint() {
        return new ValueHint("Greatest " + this.quality.text + " among " + this.filter.getMessage(), this);
    }

    public static enum Quality {
        Power("power", permanent -> permanent.getPower().getValue()),
        Toughness("toughness", permanent -> permanent.getToughness().getValue()),
        ManaValue("mana value", MageObject::getManaValue),
        PowerOrToughness("power and/or toughness", permanent -> {
            int power = permanent.getPower().getValue();
            int toughness = permanent.getToughness().getValue();
            return Math.max(power, toughness);
        });

        final String text;
        final ToIntFunction<Permanent> mapToQuality;

        private Quality(String text, ToIntFunction<Permanent> mapToQuality) {
            this.text = text;
            this.mapToQuality = mapToQuality;
        }
    }
}

