/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

public class ManaValueInGraveyard
implements DynamicValue {
    private final FilterCard filter;
    private final Integer multiplier;

    public ManaValueInGraveyard() {
        this(StaticFilters.FILTER_CARD, 1);
    }

    public ManaValueInGraveyard(FilterCard filter) {
        this(filter, 1);
    }

    public ManaValueInGraveyard(FilterCard filter, Integer multiplier) {
        this.filter = filter;
        this.multiplier = multiplier;
    }

    protected ManaValueInGraveyard(ManaValueInGraveyard dynamicValue) {
        this.filter = dynamicValue.filter;
        this.multiplier = dynamicValue.multiplier;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        UUID playerId = sourceAbility.getControllerId();
        Player player = game.getPlayer(playerId);
        if (player == null) {
            return 0;
        }
        int value = player.getGraveyard().stream().map(game::getCard).filter(Objects::nonNull).filter(card -> this.filter.match((Card)card, playerId, sourceAbility, game)).mapToInt(MageObject::getManaValue).sum();
        if (this.multiplier != null) {
            value *= this.multiplier.intValue();
        }
        return value;
    }

    @Override
    public ManaValueInGraveyard copy() {
        return new ManaValueInGraveyard(this);
    }

    public String toString() {
        return this.multiplier == null ? "X" : this.multiplier.toString();
    }

    @Override
    public String getMessage() {
        return (this.multiplier == null ? "the mana value of " : "") + this.filter.getMessage() + " in your graveyard";
    }

    @Override
    public int getSign() {
        return this.multiplier == null ? 1 : this.multiplier;
    }
}

