/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.watchers.common.PlayerLostLifeWatcher;

public enum OpponentsLostLifeCount implements DynamicValue
{
    instance;


    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return this.calculate(game, sourceAbility.getControllerId());
    }

    public int calculate(Game game, UUID controllerId) {
        PlayerLostLifeWatcher watcher = game.getState().getWatcher(PlayerLostLifeWatcher.class);
        if (watcher != null) {
            return watcher.getAllOppLifeLost(controllerId, game);
        }
        return 0;
    }

    @Override
    public OpponentsLostLifeCount copy() {
        return instance;
    }

    public String toString() {
        return "X";
    }

    @Override
    public String getMessage() {
        return "the total life lost by your opponents this turn";
    }
}

