/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import java.util.Locale;
import java.util.UUID;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.AttachEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

public class AuraReplacementEffect
extends ReplacementEffectImpl {
    public AuraReplacementEffect() {
        super(Duration.EndOfGame, Outcome.Neutral);
    }

    protected AuraReplacementEffect(AuraReplacementEffect effect) {
        super(effect);
    }

    @Override
    public AuraReplacementEffect copy() {
        return new AuraReplacementEffect(this);
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Zone fromZone = ((ZoneChangeEvent)event).getFromZone();
        Card card = game.getCard(event.getTargetId());
        if (card == null) {
            return false;
        }
        if (card.isFaceDown(game)) {
            return false;
        }
        Object object = game.getState().getValue("attachTo:" + card.getId());
        if (object != null) {
            Player player;
            if (object instanceof Permanent) {
                return false;
            }
            if (object instanceof UUID && (player = game.getPlayer((UUID)object)) != null) {
                return false;
            }
        }
        UUID targetId = null;
        boolean enchantCardInGraveyard = false;
        game.applyEffects();
        MageItem controllingPlayer = null;
        if (targetId == null) {
            SpellAbility spellAbility = card.getSpellAbility();
            if (spellAbility.getTargets().isEmpty()) {
                for (Ability ability : card.getAbilities(game)) {
                    if (!(ability instanceof SpellAbility) || SpellAbilityType.BASE_ALTERNATE != ((SpellAbility)ability).getSpellAbilityType() || ability.getTargets().isEmpty()) continue;
                    spellAbility = (SpellAbility)ability;
                    break;
                }
            }
            if (spellAbility.getTargets().isEmpty()) {
                return false;
            }
            Target target = ((Target)spellAbility.getTargets().get(0)).copy();
            Outcome auraOutcome = Outcome.BoostCreature;
            for (Effect effect : spellAbility.getEffects()) {
                if (!(effect instanceof AttachEffect)) continue;
                auraOutcome = effect.getOutcome();
                break;
            }
            enchantCardInGraveyard = target instanceof TargetCardInGraveyard;
            if (target != null) {
                target.withChooseHint("to attach " + card.getName() + " to");
                target.withNotTarget(true);
                target.clearChosen();
            }
            controllingPlayer = event.getPlayerId() != null ? game.getPlayer(event.getPlayerId()) : game.getPlayer(card.getOwnerId());
            if (target != null && controllingPlayer != null && controllingPlayer.choose(auraOutcome, target, source, game)) {
                targetId = target.getFirstTarget();
            }
        }
        Card targetCard = null;
        Permanent targetPermanent = null;
        if (enchantCardInGraveyard) {
            targetCard = game.getCard(targetId);
        } else {
            targetPermanent = game.getPermanent(targetId);
        }
        Player targetPlayer = game.getPlayer(targetId);
        if (targetCard != null || targetPermanent != null || targetPlayer != null) {
            card.removeFromZone(game, fromZone, source);
            PermanentCard permanent = new PermanentCard(card, controllingPlayer == null ? card.getOwnerId() : controllingPlayer.getId(), game);
            ZoneChangeEvent zoneChangeEvent = new ZoneChangeEvent(permanent, event.getPlayerId(), fromZone, Zone.BATTLEFIELD);
            permanent.updateZoneChangeCounter(game, zoneChangeEvent);
            game.addPermanent(permanent, 0);
            card.setZone(Zone.BATTLEFIELD, game);
            if (permanent.entersBattlefield(source, game, fromZone, true)) {
                String attachToName = null;
                if (targetCard != null) {
                    permanent.attachTo(targetCard.getId(), source, game);
                    attachToName = targetCard.getLogName();
                } else if (targetPermanent != null) {
                    targetPermanent.addAttachment(permanent.getId(), source, game);
                    attachToName = targetPermanent.getLogName();
                } else if (targetPlayer != null) {
                    targetPlayer.addAttachment(permanent.getId(), source, game);
                    attachToName = targetPlayer.getLogName();
                }
                game.applyEffects();
                game.fireEvent(zoneChangeEvent);
                if (!game.isSimulation() && controllingPlayer != null && fromZone != null && permanent != null) {
                    game.informPlayers(controllingPlayer.getLogName() + " puts " + card.getLogName() + " from " + fromZone.toString().toLowerCase(Locale.ENGLISH) + " onto the Battlefield attached to " + attachToName);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() != Zone.BATTLEFIELD || zEvent.getFromZone() == Zone.STACK) {
            return false;
        }
        Card card = game.getCard(zEvent.getTargetId());
        if (card == null) {
            return false;
        }
        if (Boolean.TRUE.equals(game.getState().getValue("EnterTransformed" + card.getId())) && card.getSecondCardFace() != null) {
            card = card.getSecondCardFace();
        }
        return card.isEnchantment(game) && card.hasSubtype(SubType.AURA, game);
    }
}

