/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageItem;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.MageSingleton;
import mage.abilities.effects.ContinuousEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import org.apache.log4j.Logger;

public class ContinuousEffectsList<T extends ContinuousEffect>
extends ArrayList<T> {
    private static final Logger logger = Logger.getLogger(ContinuousEffectsList.class);
    private final Map<UUID, Set<Ability>> effectAbilityMap = new HashMap<UUID, Set<Ability>>();

    public ContinuousEffectsList() {
    }

    public ContinuousEffectsList(ContinuousEffectsList<T> effects) {
        this.ensureCapacity(effects.size());
        for (ContinuousEffect continuousEffect : effects) {
            this.add(continuousEffect.copy());
        }
        for (Map.Entry entry : effects.effectAbilityMap.entrySet()) {
            HashSet<Ability> newSet = new HashSet<Ability>();
            for (Ability ability : (Set)entry.getValue()) {
                newSet.add(ability.copy());
            }
            this.effectAbilityMap.put((UUID)entry.getKey(), (Set<Ability>)newSet);
        }
    }

    public ContinuousEffectsList<T> copy() {
        return new ContinuousEffectsList<T>(this);
    }

    public void removeEndOfTurnEffects(Game game) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            boolean canRemove;
            ContinuousEffect entry = (ContinuousEffect)i.next();
            switch (entry.getDuration()) {
                case EndOfTurn: {
                    canRemove = true;
                    break;
                }
                case UntilEndOfYourNextTurn: {
                    canRemove = entry.isYourNextTurn(game);
                    break;
                }
                case UntilYourNextEndStep: {
                    canRemove = entry.isYourNextEndStep(game);
                    break;
                }
                default: {
                    canRemove = false;
                }
            }
            if (!canRemove) continue;
            i.remove();
            this.effectAbilityMap.remove(entry.getId());
        }
    }

    public void removeBeginningOfEndStepEffects(Game game) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            boolean canRemove;
            ContinuousEffect entry = (ContinuousEffect)i.next();
            switch (entry.getDuration()) {
                case UntilNextEndStep: {
                    canRemove = true;
                    break;
                }
                case UntilYourNextEndStep: {
                    canRemove = entry.isYourNextEndStep(game);
                    break;
                }
                default: {
                    canRemove = false;
                }
            }
            if (!canRemove) continue;
            i.remove();
            this.effectAbilityMap.remove(entry.getId());
        }
    }

    public void removeEndOfCombatEffects() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ContinuousEffect entry = (ContinuousEffect)i.next();
            if (entry.getDuration() != Duration.EndOfCombat) continue;
            i.remove();
            this.effectAbilityMap.remove(entry.getId());
        }
    }

    public void removeInactiveEffects(Game game) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ContinuousEffect entry = (ContinuousEffect)i.next();
            if (!this.isInactive(entry, game)) continue;
            i.remove();
            this.effectAbilityMap.remove(entry.getId());
        }
    }

    private boolean isInactive(T effect, Game game) {
        if (game.getState().isGameOver()) {
            return false;
        }
        Set<Ability> set = this.effectAbilityMap.get(effect.getId());
        if (set == null) {
            logger.debug((Object)("No abilities for effect found: " + effect.toString()));
            return false;
        }
        Iterator<Ability> it = set.iterator();
        block8: while (it.hasNext()) {
            Ability ability = it.next();
            if (ability == null) {
                it.remove();
                continue;
            }
            if (ability instanceof MageSingleton) {
                return false;
            }
            if (effect.isDiscarded()) {
                it.remove();
                continue;
            }
            MageObject object = game.getObject(ability.getSourceId());
            boolean isObjectInGame = ability.getSourceId() == null || object != null;
            boolean hasOwnerLeftGame = false;
            if (object instanceof Card) {
                Player owner = game.getPlayer(((Card)object).getOwnerId());
                hasOwnerLeftGame = !owner.isInGame();
            }
            switch (effect.getDuration()) {
                case WhileOnBattlefield: 
                case WhileInGraveyard: 
                case WhileOnStack: 
                case EndOfStep: 
                case EndOfCombat: 
                case EndOfGame: {
                    if (!hasOwnerLeftGame && isObjectInGame) continue block8;
                    it.remove();
                    continue block8;
                }
                case OneUse: {
                    if (!hasOwnerLeftGame && !effect.isUsed()) continue block8;
                    it.remove();
                    continue block8;
                }
                case UntilEndOfYourNextTurn: 
                case UntilYourNextEndStep: 
                case Custom: 
                case UntilYourNextTurn: 
                case UntilEndCombatOfYourNextTurn: 
                case UntilYourNextUpkeepStep: {
                    if (!effect.isInactive(ability, game)) continue block8;
                    it.remove();
                    continue block8;
                }
                case EndOfTurn: 
                case UntilNextEndStep: {
                    continue block8;
                }
                case UntilSourceLeavesBattlefield: {
                    if (!hasOwnerLeftGame && game.getState().getZone(ability.getSourceId()) == Zone.BATTLEFIELD) continue block8;
                    it.remove();
                    continue block8;
                }
                case WhileControlled: {
                    Permanent permanent = ability.getSourcePermanentIfItStillExists(game);
                    if (!hasOwnerLeftGame && permanent != null && permanent.isControlledBy(ability.getControllerId())) continue block8;
                    it.remove();
                    continue block8;
                }
            }
            throw new IllegalStateException("Effects gets unknown duration " + (Object)((Object)effect.getDuration()) + ", effect: " + effect.toString());
        }
        return set.isEmpty();
    }

    public void addEffect(T effect, Ability source) {
        Set set = this.effectAbilityMap.computeIfAbsent(effect.getId(), x -> new HashSet());
        if (set.stream().filter(ability -> ability.getSourceId().equals(source.getSourceId())).map(MageItem::getId).anyMatch(source.getId()::equals)) {
            return;
        }
        set.add(source);
        this.add(effect);
    }

    public Set<Ability> getAbility(UUID effectId) {
        return this.effectAbilityMap.computeIfAbsent(effectId, x -> new HashSet());
    }

    public void removeTemporaryEffects() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ContinuousEffect entry = (ContinuousEffect)i.next();
            if (!entry.isTemporary()) continue;
            i.remove();
            this.effectAbilityMap.remove(entry.getId());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.effectAbilityMap.clear();
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof ContinuousEffect)) {
            return false;
        }
        ContinuousEffect need = (ContinuousEffect)object;
        for (ContinuousEffect test : this) {
            if (need.equals(test)) {
                return true;
            }
            if (!need.getId().equals(test.getId())) continue;
            return true;
        }
        return false;
    }
}

