/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class CreateTokenCopySourceEffect
extends OneShotEffect {
    private final int number;
    private final boolean tapped;

    public CreateTokenCopySourceEffect() {
        this(1);
    }

    public CreateTokenCopySourceEffect(int copies) {
        this(copies, false);
    }

    public CreateTokenCopySourceEffect(int copies, boolean tapped) {
        super(Outcome.PutCreatureInPlay);
        this.number = copies;
        this.tapped = tapped;
        this.staticText = "create " + CardUtil.numberToText(copies, "a") + " " + (tapped ? "tapped " : "") + (copies > 1 ? "tokens that are copies of " : "token that's a copy of ") + "{this}";
    }

    protected CreateTokenCopySourceEffect(CreateTokenCopySourceEffect effect) {
        super(effect);
        this.number = effect.number;
        this.tapped = effect.tapped;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false, this.number, this.tapped, false);
        effect.setTargetPointer(new FixedTarget(source.getSourceId(), game));
        return effect.apply(game, source);
    }

    @Override
    public CreateTokenCopySourceEffect copy() {
        return new CreateTokenCopySourceEffect(this);
    }
}

