/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PreventDamageAndRemoveCountersWatcher;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class PreventDamageAndRemoveCountersEffect
extends PreventionEffectImpl {
    private final boolean thatMany;
    private final boolean whileHasCounter;

    public static Watcher createWatcher() {
        return new PreventDamageAndRemoveCountersWatcher();
    }

    public PreventDamageAndRemoveCountersEffect(boolean thatMany, boolean whileHasCounter, boolean textFromIt) {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false, false);
        this.thatMany = thatMany;
        this.whileHasCounter = whileHasCounter;
        this.staticText = "If damage would be dealt to {this}" + (whileHasCounter ? " while it has a +1/+1 counter on it" : "") + ", prevent that damage and remove " + (thatMany ? "that many +1/+1 counters" : "a +1/+1 counter") + " from " + (textFromIt ? "it" : "{this}");
    }

    public PreventDamageAndRemoveCountersEffect withPhantomText() {
        this.staticText = "If damage would be dealt to {this}, prevent that damage. Remove a +1/+1 counter from {this}.";
        return this;
    }

    protected PreventDamageAndRemoveCountersEffect(PreventDamageAndRemoveCountersEffect effect) {
        super(effect);
        this.thatMany = effect.thatMany;
        this.whileHasCounter = effect.whileHasCounter;
    }

    @Override
    public PreventDamageAndRemoveCountersEffect copy() {
        return new PreventDamageAndRemoveCountersEffect(this);
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int amountRemovedThisTime;
        int damageAmount = event.getAmount();
        this.preventDamageAction(event, source, game);
        Permanent permanent = game.getPermanent(source.getSourceId());
        PreventDamageAndRemoveCountersWatcher watcher = game.getState().getWatcher(PreventDamageAndRemoveCountersWatcher.class);
        if (permanent == null || watcher == null || damageAmount <= 0) {
            return false;
        }
        MageObjectReference mor = new MageObjectReference(source.getId(), source.getStackMomentSourceZCC(), game);
        int beforeCount = permanent.getCounters(game).getCount(CounterType.P1P1);
        if (this.thatMany) {
            permanent.removeCounters(CounterType.P1P1.createInstance(damageAmount), source, game);
        } else if (!watcher.hadMORCounterRemovedThisBatch(mor)) {
            permanent.removeCounters(CounterType.P1P1.createInstance(), source, game);
        }
        int amountRemovedInTotal = amountRemovedThisTime = beforeCount - permanent.getCounters(game).getCount(CounterType.P1P1);
        if (!watcher.hadMORCounterRemovedThisBatch(mor)) {
            watcher.addMOR(mor);
        } else {
            amountRemovedInTotal += ((Integer)((Effect)source.getEffects().get(0)).getValue("CounterRemoved")).intValue();
        }
        this.onDamagePrevented(event, source, game, amountRemovedInTotal, amountRemovedThisTime);
        return false;
    }

    protected void onDamagePrevented(GameEvent event, Ability source, Game game, int amountRemovedInTotal, int amountRemovedThisTime) {
        source.getEffects().setValue("CounterRemoved", amountRemovedInTotal);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (!super.applies(event, source, game) || permanent == null || !event.getTargetId().equals(source.getSourceId())) {
            return false;
        }
        if (this.whileHasCounter && !permanent.getCounters(game).containsKey(CounterType.P1P1)) {
            PreventDamageAndRemoveCountersWatcher watcher = game.getState().getWatcher(PreventDamageAndRemoveCountersWatcher.class);
            MageObjectReference mor = new MageObjectReference(source.getId(), source.getStackMomentSourceZCC(), game);
            return watcher != null && watcher.hadMORCounterRemovedThisBatch(mor);
        }
        return true;
    }
}

