/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.EachTargetPointer;

public class AttachTargetToTargetEffect
extends OneShotEffect {
    public AttachTargetToTargetEffect() {
        super(Outcome.BoostCreature);
        this.setTargetPointer(new EachTargetPointer());
    }

    private AttachTargetToTargetEffect(AttachTargetToTargetEffect effect) {
        super(effect);
    }

    @Override
    public AttachTargetToTargetEffect copy() {
        return new AttachTargetToTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(game::getPermanent).filter(Objects::nonNull).collect(Collectors.toList());
        return permanents.size() >= 2 && ((Permanent)permanents.get(1)).addAttachment(((Permanent)permanents.get(0)).getId(), source, game);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        if (mode.getTargets().size() != 2) {
            throw new IllegalStateException("It must have two targets, but found " + mode.getTargets().size());
        }
        return "attach " + ((Target)mode.getTargets().get(0)).getDescription() + " to " + ((Target)mode.getTargets().get(1)).getDescription();
    }
}

