/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterSpell;
import mage.filter.FilterStackObject;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

public class CantBeCounteredControlledEffect
extends ContinuousRuleModifyingEffectImpl {
    private FilterSpell filterTarget;
    private FilterStackObject filterSource;

    public CantBeCounteredControlledEffect(FilterSpell filterTarget, Duration duration) {
        this(filterTarget, null, duration);
    }

    public CantBeCounteredControlledEffect(FilterSpell filterTarget, FilterStackObject filterSource, Duration duration) {
        super(duration, Outcome.Benefit);
        this.filterTarget = filterTarget;
        this.filterSource = filterSource;
        this.setText();
    }

    protected CantBeCounteredControlledEffect(CantBeCounteredControlledEffect effect) {
        super(effect);
        this.filterTarget = effect.filterTarget.copy();
        if (effect.filterSource != null) {
            this.filterSource = effect.filterSource.copy();
        }
    }

    @Override
    public CantBeCounteredControlledEffect copy() {
        return new CantBeCounteredControlledEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID controllerId = source.getControllerId();
        Spell spell = game.getStack().getSpell(event.getTargetId());
        StackObject counterSource = game.getStack().getStackObject(event.getSourceId());
        return spell != null && spell.isControlledBy(controllerId) && this.filterTarget.match(spell, controllerId, source, game) && (this.filterSource == null || this.filterSource.match(counterSource, controllerId, source, game));
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.filterTarget.getMessage());
        if (!this.filterTarget.getMessage().contains("you control")) {
            sb.append(" you control");
        }
        sb.append(" can't be countered");
        if (this.filterSource != null) {
            sb.append(" by ").append(this.filterSource.getMessage());
        }
        if (this.duration == Duration.EndOfTurn) {
            sb.append(" this turn");
        }
        this.staticText = sb.toString();
    }
}

