/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterObject;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;

public class CantBeTargetedSourceEffect
extends ContinuousRuleModifyingEffectImpl {
    private final FilterObject filterSource;

    public CantBeTargetedSourceEffect(FilterObject filterSource, Duration duration) {
        super(duration, Outcome.Benefit);
        this.filterSource = filterSource;
        this.setText();
    }

    protected CantBeTargetedSourceEffect(CantBeTargetedSourceEffect effect) {
        super(effect);
        this.filterSource = effect.filterSource.copy();
    }

    @Override
    public CantBeTargetedSourceEffect copy() {
        return new CantBeTargetedSourceEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGET;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        StackObject stackObject;
        MageObject sourceObject;
        return event.getTargetId().equals(source.getSourceId()) && this.filterSource.match(sourceObject = (stackObject = game.getStack().getStackObject(event.getSourceId())) instanceof StackAbility ? ((StackAbility)stackObject).getSourceObject(game) : stackObject, game);
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append("{this} can't be the target of ");
        sb.append(this.filterSource.getMessage());
        if (!this.duration.toString().isEmpty()) {
            sb.append(' ').append(this.duration.toString());
        }
        this.staticText = sb.toString();
    }
}

