/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterObject;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;

public class CantBeTargetedTargetEffect
extends ContinuousRuleModifyingEffectImpl {
    private final FilterObject filterSource;
    private final TargetController targetController;

    public CantBeTargetedTargetEffect(FilterObject filterSource, Duration duration, TargetController targetController) {
        super(duration, Outcome.Benefit, false, false);
        this.targetController = targetController;
        this.filterSource = filterSource;
    }

    protected CantBeTargetedTargetEffect(CantBeTargetedTargetEffect effect) {
        super(effect);
        this.filterSource = effect.filterSource.copy();
        this.targetController = effect.targetController;
    }

    @Override
    public CantBeTargetedTargetEffect copy() {
        return new CantBeTargetedTargetEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGET;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (this.getTargetPointer().getTargets(game, source).contains(event.getTargetId())) {
            if (this.targetController == TargetController.OPPONENT && !game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
                return false;
            }
            StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
            MageObject sourceObject = stackObject instanceof StackAbility ? ((StackAbility)stackObject).getSourceObject(game) : stackObject;
            if (this.filterSource.match(sourceObject, game)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "it"));
        sb.append(" can't be the target of ");
        sb.append(this.filterSource.getMessage());
        if (!this.duration.toString().isEmpty()) {
            sb.append(' ');
            if (this.duration == Duration.EndOfTurn) {
                sb.append("this turn");
            } else {
                sb.append(this.duration.toString());
            }
        }
        return sb.toString();
    }
}

