/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.ChoiceImpl;
import mage.constants.ModeChoice;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class ChooseModeEffect
extends OneShotEffect {
    protected final List<ModeChoice> modes = new ArrayList<ModeChoice>();
    protected final String message;

    public ChooseModeEffect(ModeChoice ... modes) {
        super(Outcome.Neutral);
        this.modes.addAll(Arrays.asList(modes));
        this.message = ChooseModeEffect.makeMessage(this.modes);
        this.staticText = "choose " + this.message;
    }

    protected ChooseModeEffect(ChooseModeEffect effect) {
        super(effect);
        this.modes.addAll(effect.modes);
        this.message = effect.message;
    }

    @Override
    public ChooseModeEffect copy() {
        return new ChooseModeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            sourcePermanent = game.getPermanentEntering(source.getSourceId());
        }
        if (controller == null || sourcePermanent == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage(this.message + "? (" + CardUtil.getSourceLogName(game, source) + ')');
        choice.getChoices().addAll(this.modes.stream().map(ModeChoice::toString).collect(Collectors.toList()));
        if (!controller.choose(Outcome.Neutral, choice, game)) {
            return false;
        }
        game.informPlayers(sourcePermanent.getLogName() + ": " + controller.getLogName() + " has chosen " + choice.getChoice());
        game.getState().setValue(source.getSourceId() + "_modeChoice", choice.getChoice());
        sourcePermanent.addInfo("_modeChoice", "<font color = 'blue'>Chosen mode: " + choice.getChoice() + "</font>", game);
        return true;
    }

    private static String makeMessage(List<ModeChoice> modeChoices) {
        return CardUtil.concatWithOr(modeChoices.stream().map(ModeChoice::toString).collect(Collectors.toList()));
    }
}

