/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

public class ChooseSecretOpponentEffect
extends OneShotEffect {
    public static final String SECRET_OPPONENT = "_secOpp";
    public static final String SECRET_OWNER = "_secOwn";

    public ChooseSecretOpponentEffect() {
        super(Outcome.Neutral);
        this.staticText = "secretly choose an opponent";
    }

    protected ChooseSecretOpponentEffect(ChooseSecretOpponentEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = game.getObject(source);
        }
        if (controller == null || mageObject == null) {
            return false;
        }
        TargetOpponent targetOpponent = new TargetOpponent(true);
        targetOpponent.withTargetName("opponent (secretly)");
        controller.choose(this.outcome, targetOpponent, source, game);
        if (targetOpponent.getFirstTarget() == null) {
            return false;
        }
        game.informPlayers(mageObject.getName() + ": " + controller.getLogName() + " has secretly chosen an opponent.");
        ChooseSecretOpponentEffect.setChosenPlayer(targetOpponent.getFirstTarget(), source, game);
        ChooseSecretOpponentEffect.setSecretOwner(controller.getId(), source, game);
        if (!(mageObject instanceof Permanent)) {
            return true;
        }
        ((Permanent)mageObject).addInfo(SECRET_OPPONENT, CardUtil.addToolTipMarkTags(controller.getLogName() + " has secretly chosen an opponent."), game);
        return true;
    }

    public static void setChosenPlayer(UUID value, Ability source, Game game) {
        game.getState().setValue(ChooseSecretOpponentEffect.getthing(source, game) + SECRET_OPPONENT, value);
    }

    public static UUID getChosenPlayer(Ability source, Game game) {
        return (UUID)game.getState().getValue(ChooseSecretOpponentEffect.getthing(source, game) + SECRET_OPPONENT);
    }

    public static void setSecretOwner(UUID value, Ability source, Game game) {
        game.getState().setValue(ChooseSecretOpponentEffect.getthing(source, game) + SECRET_OWNER, value);
    }

    public static UUID getSecretOwner(Ability source, Game game) {
        return (UUID)game.getState().getValue(ChooseSecretOpponentEffect.getthing(source, game) + SECRET_OWNER);
    }

    private static String getthing(Ability source, Game game) {
        if (game.getPermanentEntering(source.getSourceId()) != null) {
            return "" + source.getSourceId() + '_' + (game.getPermanentEntering(source.getSourceId()).getZoneChangeCounter(game) + 1);
        }
        if (game.getPermanentOrLKIBattlefield(source.getSourceId()) != null) {
            return "" + source.getSourceId() + '_' + game.getPermanentOrLKIBattlefield(source.getSourceId()).getZoneChangeCounter(game);
        }
        return "Does not exist";
    }

    @Override
    public ChooseSecretOpponentEffect copy() {
        return new ChooseSecretOpponentEffect(this);
    }
}

