/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Iterator;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.functions.StackObjectCopyApplier;

public abstract class CopySpellForEachItCouldTargetEffect
extends OneShotEffect {
    protected CopySpellForEachItCouldTargetEffect() {
        super(Outcome.Copy);
    }

    protected CopySpellForEachItCouldTargetEffect(CopySpellForEachItCouldTargetEffect effect) {
        super(effect);
    }

    protected abstract StackObject getStackObject(Game var1, Ability var2);

    protected abstract Player getPlayer(Game var1, Ability var2);

    protected abstract List<MageObjectReferencePredicate> prepareCopiesWithTargets(StackObject var1, Player var2, Ability var3, Game var4);

    @Override
    public boolean apply(Game game, Ability source) {
        Player actingPlayer = this.getPlayer(game, source);
        StackObject stackObject = this.getStackObject(game, source);
        if (actingPlayer == null || stackObject == null) {
            return false;
        }
        List<MageObjectReferencePredicate> copies = this.prepareCopiesWithTargets(stackObject, actingPlayer, source, game);
        stackObject.createCopyOnStack(game, source, actingPlayer.getId(), false, copies.size(), new ForEachCopyApplier(copies));
        return true;
    }

    private static final class ForEachCopyApplier
    implements StackObjectCopyApplier {
        private final Iterator<MageObjectReferencePredicate> newTargetTypes;

        private ForEachCopyApplier(List<MageObjectReferencePredicate> copiesWithTargets) {
            this.newTargetTypes = copiesWithTargets.iterator();
        }

        @Override
        public void modifySpell(StackObject stackObject, Game game) {
        }

        @Override
        public MageObjectReferencePredicate getNextNewTargetType() {
            if (this.newTargetTypes.hasNext()) {
                return this.newTargetTypes.next();
            }
            return null;
        }
    }
}

