/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;

public class CounterTargetEffect
extends OneShotEffect {
    public CounterTargetEffect() {
        super(Outcome.Detriment);
    }

    protected CounterTargetEffect(CounterTargetEffect effect) {
        super(effect);
    }

    @Override
    public CounterTargetEffect copy() {
        return new CounterTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean countered = false;
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            if (!game.getStack().counter(targetId, source, game)) continue;
            countered = true;
        }
        return countered;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "counter " + this.getTargetPointer().describeTargets(mode.getTargets(), "that spell");
    }
}

