/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.Mode;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.FixedTargets;
import mage.util.functions.CopyApplier;
import mage.util.functions.CopyTokenFunction;
import mage.util.functions.EmptyCopyApplier;

public class CreateTokenCopyTargetEffect
extends OneShotEffect {
    private final Set<Class<? extends Ability>> abilityClazzesToRemove;
    private final List<Permanent> addedTokenPermanents;
    private final List<Ability> additionalAbilities;
    private final CardType additionalCardType;
    private final List<SubType> additionalSubTypes = new ArrayList<SubType>();
    private final UUID attackedPlayer;
    private UUID attachedTo = null;
    private final boolean attacking;
    private boolean becomesArtifact;
    private ObjectColor onlyColor;
    private ObjectColor extraColor;
    private CounterType counter;
    private final boolean gainsFlying;
    private boolean hasHaste;
    private boolean isntLegendary = false;
    private int number;
    private int numberOfCounters;
    private SubType onlySubType;
    private final UUID playerId;
    private final boolean tapped;
    private Permanent savedPermanent = null;
    private int startingLoyalty = -1;
    private final int tokenPower;
    private final int tokenToughness;
    private boolean useLKI = false;
    private PermanentModifier permanentModifier = null;

    public CreateTokenCopyTargetEffect(boolean useLKI) {
        this();
        this.useLKI = useLKI;
    }

    public CreateTokenCopyTargetEffect() {
        this((UUID)null);
    }

    public CreateTokenCopyTargetEffect(CounterType counter, int numberOfCounters) {
        this((UUID)null);
        this.counter = counter;
        this.numberOfCounters = numberOfCounters;
    }

    public CreateTokenCopyTargetEffect(UUID playerId) {
        this(playerId, null, false);
    }

    public CreateTokenCopyTargetEffect(UUID playerId, CardType additionalCardType, boolean hasHaste) {
        this(playerId, additionalCardType, hasHaste, 1);
    }

    public CreateTokenCopyTargetEffect(UUID playerId, CardType additionalCardType, boolean hasHaste, int number) {
        this(playerId, additionalCardType, hasHaste, number, false, false);
    }

    public CreateTokenCopyTargetEffect(UUID playerId, CardType additionalCardType, boolean hasHaste, int number, boolean tapped, boolean attacking) {
        this(playerId, additionalCardType, hasHaste, number, tapped, attacking, null);
    }

    public CreateTokenCopyTargetEffect(UUID playerId, CardType additionalCardType, boolean hasHaste, int number, boolean tapped, boolean attacking, UUID attackedPlayer) {
        this(playerId, additionalCardType, hasHaste, number, tapped, attacking, attackedPlayer, Integer.MIN_VALUE, Integer.MIN_VALUE, false);
    }

    public CreateTokenCopyTargetEffect(UUID playerId, CardType additionalCardType, boolean hasHaste, int number, boolean tapped, boolean attacking, UUID attackedPlayer, int power, int toughness, boolean gainsFlying) {
        super(Outcome.PutCreatureInPlay);
        this.playerId = playerId;
        this.additionalCardType = additionalCardType;
        this.hasHaste = hasHaste;
        this.addedTokenPermanents = new ArrayList<Permanent>();
        this.number = number;
        this.tapped = tapped;
        this.attacking = attacking;
        this.attackedPlayer = attackedPlayer;
        this.tokenPower = power;
        this.tokenToughness = toughness;
        this.gainsFlying = gainsFlying;
        this.abilityClazzesToRemove = new HashSet<Class<? extends Ability>>();
        this.additionalAbilities = new ArrayList<Ability>();
    }

    protected CreateTokenCopyTargetEffect(CreateTokenCopyTargetEffect effect) {
        super(effect);
        this.abilityClazzesToRemove = new HashSet<Class<? extends Ability>>(effect.abilityClazzesToRemove);
        this.addedTokenPermanents = new ArrayList<Permanent>(effect.addedTokenPermanents);
        this.additionalAbilities = new ArrayList<Ability>(effect.additionalAbilities);
        this.additionalCardType = effect.additionalCardType;
        this.additionalSubTypes.addAll(effect.additionalSubTypes);
        this.attackedPlayer = effect.attackedPlayer;
        this.attachedTo = effect.attachedTo;
        this.attacking = effect.attacking;
        this.becomesArtifact = effect.becomesArtifact;
        this.onlyColor = effect.onlyColor;
        this.extraColor = effect.extraColor;
        this.counter = effect.counter;
        this.gainsFlying = effect.gainsFlying;
        this.hasHaste = effect.hasHaste;
        this.isntLegendary = effect.isntLegendary;
        this.number = effect.number;
        this.numberOfCounters = effect.numberOfCounters;
        this.onlySubType = effect.onlySubType;
        this.playerId = effect.playerId;
        this.savedPermanent = effect.savedPermanent;
        this.startingLoyalty = effect.startingLoyalty;
        this.tapped = effect.tapped;
        this.tokenPower = effect.tokenPower;
        this.tokenToughness = effect.tokenToughness;
        this.useLKI = effect.useLKI;
        this.permanentModifier = effect.permanentModifier;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        UUID targetId = this.getTargetPointer() instanceof FixedTarget ? ((FixedTarget)this.getTargetPointer()).getTarget() : this.getTargetPointer().getFirst(game, source);
        Permanent permanent = this.savedPermanent != null ? this.savedPermanent : (this.useLKI ? this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source) : game.getPermanentOrLKIBattlefield(targetId));
        Card copyFrom = null;
        CopyApplier applier = null;
        if (permanent != null) {
            Permanent copyFromPermanent = permanent;
            for (ContinuousEffect continuousEffect : game.getState().getContinuousEffects().getLayeredEffects(game)) {
                MageObject object;
                CopyEffect copyEffect;
                if (!(continuousEffect instanceof CopyEffect) || !(copyEffect = (CopyEffect)continuousEffect).getSourceId().equals(permanent.getId()) || !((object = ((CopyEffect)continuousEffect).getTarget()) instanceof Permanent)) continue;
                copyFromPermanent = (Permanent)object;
                if (copyEffect.getApplier() == null) continue;
                applier = copyEffect.getApplier();
            }
            if (applier == null) {
                if (permanent.isCopy() && permanent.getCopyFrom() instanceof Permanent) {
                    copyFromPermanent = (Permanent)permanent.getCopyFrom();
                }
                applier = new EmptyCopyApplier();
            }
            copyFrom = copyFromPermanent;
        } else {
            copyFrom = game.getCard(this.getTargetPointer().getFirst(game, source));
            applier = new EmptyCopyApplier();
        }
        if (copyFrom == null) {
            return false;
        }
        Token token = CopyTokenFunction.createTokenCopy(copyFrom, game);
        ((CopyApplier)applier).apply(game, token, source, targetId);
        if (this.becomesArtifact) {
            token.addCardType(CardType.ARTIFACT);
        }
        if (this.isntLegendary) {
            token.removeSuperType(SuperType.LEGENDARY);
        }
        if (this.startingLoyalty != -1) {
            token.setStartingLoyalty(this.startingLoyalty);
        }
        if (this.additionalCardType != null) {
            token.addCardType(this.additionalCardType);
        }
        if (this.hasHaste) {
            token.addAbility(HasteAbility.getInstance());
        }
        if (this.gainsFlying) {
            token.addAbility(FlyingAbility.getInstance());
        }
        if (this.tokenPower != Integer.MIN_VALUE) {
            token.removePTCDA();
            token.setPower(this.tokenPower);
        }
        if (this.tokenToughness != Integer.MIN_VALUE) {
            token.removePTCDA();
            token.setToughness(this.tokenToughness);
        }
        if (this.onlySubType != null) {
            token.removeAllCreatureTypes();
            token.addSubType(this.onlySubType);
        }
        if (!this.additionalSubTypes.isEmpty()) {
            for (SubType subType : this.additionalSubTypes) {
                token.addSubType(subType);
            }
        }
        if (this.onlyColor != null) {
            token.setColor(this.onlyColor);
        }
        if (this.extraColor != null) {
            token.getColor().addColor(this.extraColor);
        }
        this.additionalAbilities.stream().forEach(token::addAbility);
        if (this.permanentModifier != null) {
            this.permanentModifier.apply(token);
        }
        if (!this.abilityClazzesToRemove.isEmpty()) {
            ArrayList<Ability> abilitiesToRemoveTmp = new ArrayList<Ability>();
            for (Ability ability : token.getAbilities()) {
                if (!this.abilityClazzesToRemove.contains(ability.getClass())) continue;
                abilitiesToRemoveTmp.add(ability);
            }
            for (Ability ability : abilitiesToRemoveTmp) {
                token.removeAbilities(ability.getSubAbilities());
                token.removeAbility(ability);
            }
        }
        token.putOntoBattlefield(this.number, game, source, this.playerId == null ? source.getControllerId() : this.playerId, this.tapped, this.attacking, this.attackedPlayer, this.attachedTo);
        for (UUID uUID : token.getLastAddedTokenIds()) {
            Permanent tokenPermanent = game.getPermanent(uUID);
            if (tokenPermanent == null) continue;
            this.addedTokenPermanents.add(tokenPermanent);
            if (this.counter == null || this.numberOfCounters <= 0) continue;
            tokenPermanent.addCounters(this.counter.createInstance(this.numberOfCounters), source.getControllerId(), source, game);
        }
        return true;
    }

    @Override
    public CreateTokenCopyTargetEffect copy() {
        return new CreateTokenCopyTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder("create ");
        if (this.number == 1) {
            sb.append("a ");
            if (this.tapped && !this.attacking) {
                sb.append("tapped ");
            }
            sb.append("token that's a copy of ");
        } else {
            sb.append(this.number);
            sb.append(" ");
            if (this.tapped && !this.attacking) {
                sb.append("tapped ");
            }
            sb.append("tokens that are copies of ");
        }
        sb.append(this.getTargetPointer().describeTargets(mode.getTargets(), "it"));
        if (this.attacking) {
            sb.append(" that are");
            if (this.tapped) {
                sb.append(" tapped and");
            }
            sb.append(" attacking");
        }
        return sb.toString();
    }

    public List<Permanent> getAddedPermanents() {
        return this.addedTokenPermanents;
    }

    public CreateTokenCopyTargetEffect withAdditionalSubType(SubType additionalSubType) {
        this.additionalSubTypes.add(additionalSubType);
        return this;
    }

    public CreateTokenCopyTargetEffect setOnlySubType(SubType onlySubType) {
        this.onlySubType = onlySubType;
        return this;
    }

    public CreateTokenCopyTargetEffect setOnlyColor(ObjectColor color) {
        this.onlyColor = color;
        return this;
    }

    public CreateTokenCopyTargetEffect setExtraColor(ObjectColor extraColor) {
        this.extraColor = extraColor;
        return this;
    }

    public CreateTokenCopyTargetEffect setUseLKI(boolean useLKI) {
        this.useLKI = useLKI;
        return this;
    }

    public CreateTokenCopyTargetEffect setBecomesArtifact(boolean becomesArtifact) {
        this.becomesArtifact = becomesArtifact;
        return this;
    }

    public CreateTokenCopyTargetEffect setIsntLegendary(boolean isntLegendary) {
        this.isntLegendary = isntLegendary;
        return this;
    }

    public CreateTokenCopyTargetEffect setHasHaste(boolean hasHaste) {
        this.hasHaste = hasHaste;
        return this;
    }

    public CreateTokenCopyTargetEffect setStartingLoyalty(int startingLoyalty) {
        this.startingLoyalty = startingLoyalty;
        return this;
    }

    public CreateTokenCopyTargetEffect setNumber(int number) {
        this.number = number;
        return this;
    }

    public CreateTokenCopyTargetEffect addAbilityClassesToRemoveFromTokens(Class<? extends Ability> clazz) {
        this.abilityClazzesToRemove.add(clazz);
        return this;
    }

    public CreateTokenCopyTargetEffect addAdditionalAbilities(Ability ... abilities) {
        this.additionalAbilities.addAll(Arrays.asList(abilities));
        return this;
    }

    public CreateTokenCopyTargetEffect setSavedPermanent(Permanent savedPermanent) {
        this.savedPermanent = savedPermanent;
        return this;
    }

    public CreateTokenCopyTargetEffect setPermanentModifier(PermanentModifier permanentModifier) {
        this.permanentModifier = permanentModifier;
        return this;
    }

    public CreateTokenCopyTargetEffect setAttachedTo(UUID attachedTo) {
        this.attachedTo = attachedTo;
        return this;
    }

    public void sacrificeTokensCreatedAtNextEndStep(Game game, Ability source) {
        this.removeTokensCreatedAt(game, source, false, PhaseStep.END_TURN, TargetController.ANY);
    }

    public void exileTokensCreatedAtNextEndStep(Game game, Ability source) {
        this.removeTokensCreatedAt(game, source, true, PhaseStep.END_TURN, TargetController.ANY);
    }

    public void removeTokensCreatedAt(Game game, Ability source, boolean exile, PhaseStep phaseStep, TargetController targetController) {
        DelayedTriggeredAbility exileAbility;
        SacrificeTargetEffect effect = exile ? new ExileTargetEffect(null, "", Zone.BATTLEFIELD).setText("exile the token copies") : new SacrificeTargetEffect("sacrifice the token copies", source.getControllerId());
        effect.setTargetPointer(new FixedTargets(new ArrayList<Permanent>(this.addedTokenPermanents), game));
        switch (phaseStep) {
            case END_TURN: {
                exileAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect, targetController);
                break;
            }
            case END_COMBAT: {
                exileAbility = new AtTheEndOfCombatDelayedTriggeredAbility(effect);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported PhaseStep in CreateTokenCopyTargetEffect::removeTokensCreatedAt");
            }
        }
        game.addDelayedTriggeredAbility(exileAbility, source);
    }

    @FunctionalInterface
    public static interface PermanentModifier {
        public void apply(Token var1);
    }
}

