/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.util.CardUtil;

public class CreateTokenEffect
extends OneShotEffect {
    private final List<Token> tokens = new ArrayList<Token>();
    private final DynamicValue amount;
    private final boolean tapped;
    private final boolean attacking;
    private String additionalRules;
    private boolean oldPhrasing = false;
    private List<UUID> lastAddedTokenIds = new ArrayList<UUID>();
    private CounterType counterType;
    private DynamicValue numberOfCounters;

    public CreateTokenEffect(Token token) {
        this(token, StaticValue.get(1));
    }

    public CreateTokenEffect(Token token, int amount) {
        this(token, StaticValue.get(amount));
    }

    public CreateTokenEffect(Token token, DynamicValue amount) {
        this(token, amount, false, false);
    }

    public CreateTokenEffect(Token token, int amount, boolean tapped) {
        this(token, amount, tapped, false);
    }

    public CreateTokenEffect(Token token, int amount, boolean tapped, boolean attacking) {
        this(token, StaticValue.get(amount), tapped, attacking);
    }

    public CreateTokenEffect(Token token, DynamicValue amount, boolean tapped, boolean attacking) {
        super(Outcome.PutCreatureInPlay);
        if (token == null) {
            throw new IllegalArgumentException("Wrong code usage. Token provided to CreateTokenEffect must not be null.");
        }
        this.tokens.add(token);
        this.amount = amount.copy();
        this.tapped = tapped;
        this.attacking = attacking;
        this.setText();
    }

    protected CreateTokenEffect(CreateTokenEffect effect) {
        super(effect);
        this.amount = effect.amount.copy();
        for (Token token : effect.tokens) {
            this.tokens.add(token.copy());
        }
        this.tapped = effect.tapped;
        this.attacking = effect.attacking;
        this.lastAddedTokenIds.addAll(effect.lastAddedTokenIds);
        this.counterType = effect.counterType;
        this.numberOfCounters = effect.numberOfCounters;
        this.additionalRules = effect.additionalRules;
        this.oldPhrasing = effect.oldPhrasing;
    }

    public CreateTokenEffect entersWithCounters(CounterType counterType, DynamicValue numberOfCounters) {
        this.counterType = counterType;
        this.numberOfCounters = numberOfCounters;
        return this;
    }

    public CreateTokenEffect withAdditionalTokens(Token ... tokens) {
        this.tokens.addAll(Arrays.asList(tokens));
        this.setText();
        return this;
    }

    @Override
    public CreateTokenEffect copy() {
        return new CreateTokenEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int value = this.amount.calculate(game, source, this);
        this.tokens.get(0).putOntoBattlefield(value, game, source, source.getControllerId(), this.tapped, this.attacking, null, null, true, this.tokens);
        this.lastAddedTokenIds = this.tokens.get(0).getLastAddedTokenIds();
        if (this.counterType != null) {
            for (UUID tokenId : this.lastAddedTokenIds) {
                Permanent tokenPermanent = game.getPermanent(tokenId);
                if (tokenPermanent == null) continue;
                tokenPermanent.addCounters(this.counterType.createInstance(this.numberOfCounters.calculate(game, source, this)), source.getControllerId(), source, game);
            }
        }
        return true;
    }

    public List<UUID> getLastAddedTokenIds() {
        return this.lastAddedTokenIds;
    }

    public void exileTokensCreatedAtNextEndStep(Game game, Ability source) {
        this.removeTokensCreatedAt(game, source, true, PhaseStep.END_TURN, TargetController.ANY);
    }

    public void removeTokensCreatedAt(Game game, Ability source, boolean exile, PhaseStep phaseStep, TargetController targetController) {
        DelayedTriggeredAbility exileAbility;
        List permanents = this.getLastAddedTokenIds().stream().map(game::getPermanent).filter(Objects::nonNull).collect(Collectors.toList());
        SacrificeTargetEffect effect = exile ? new ExileTargetEffect(null, "", Zone.BATTLEFIELD).setText("exile those tokens") : new SacrificeTargetEffect("sacrifice those tokens", source.getControllerId());
        effect.setTargetPointer(new FixedTargets(permanents, game));
        switch (phaseStep) {
            case END_TURN: {
                exileAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect, targetController);
                break;
            }
            case END_COMBAT: {
                exileAbility = new AtTheEndOfCombatDelayedTriggeredAbility(effect);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported PhaseStep in CreateTokenEffect::removeTokensCreatedAt");
            }
        }
        game.addDelayedTriggeredAbility(exileAbility, source);
    }

    public CreateTokenEffect withAdditionalRules(String additionalRules) {
        this.additionalRules = additionalRules;
        this.setText();
        return this;
    }

    public CreateTokenEffect withTextOptions(boolean oldPhrasing) {
        this.oldPhrasing = oldPhrasing;
        this.setText();
        return this;
    }

    private void setText() {
        String message;
        boolean singular = this.amount.toString().equals("1");
        StringBuilder sb = new StringBuilder("create ");
        for (int i = 0; i < this.tokens.size(); ++i) {
            int tokenLocation;
            String tokenDescription;
            if (i > 0) {
                if (this.tokens.size() > 2) {
                    sb.append(", ");
                } else {
                    sb.append(" ");
                }
                if (i + 1 == this.tokens.size()) {
                    sb.append("and ");
                }
            }
            if ((tokenDescription = this.tokens.get(i).getDescription()).contains(", a legendary")) {
                sb.append(tokenDescription);
                continue;
            }
            if (this.oldPhrasing) {
                tokenDescription = tokenDescription.replace("token with \"", singular ? "token. It has \"" : "tokens. They have \"");
            }
            if (singular) {
                if (this.tapped && !this.attacking) {
                    sb.append("a tapped ");
                    sb.append(tokenDescription);
                    continue;
                }
                sb.append(CardUtil.addArticle(tokenDescription));
                continue;
            }
            sb.append(CardUtil.numberToText(this.amount.toString())).append(' ');
            if (this.tapped && !this.attacking) {
                sb.append("tapped ");
            }
            sb.append(tokenDescription);
            if (tokenDescription.endsWith("token")) {
                sb.append("s");
            }
            if ((tokenLocation = sb.indexOf("token ")) == -1) continue;
            sb.replace(tokenLocation, tokenLocation + 6, "tokens ");
        }
        if (this.attacking) {
            if (singular && this.tokens.size() == 1) {
                sb.append(" that's");
            } else {
                sb.append(" that are");
            }
            if (this.tapped) {
                sb.append(" tapped and");
            }
            sb.append(" attacking");
        }
        if (!(message = this.amount.getMessage()).isEmpty()) {
            if (this.amount.toString().equals("X")) {
                if (sb.toString().endsWith(".\"")) {
                    sb.replace(sb.length() - 2, sb.length(), ",\" where X is ");
                } else {
                    sb.append(", where X is ");
                }
            } else {
                sb.append(" for each ");
            }
        }
        sb.append(message);
        if (this.additionalRules != null) {
            sb.append(this.additionalRules);
        }
        this.staticText = sb.toString();
    }
}

