/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class DestroyTargetEffect
extends OneShotEffect {
    protected boolean noRegen;

    public DestroyTargetEffect() {
        this(false);
    }

    public DestroyTargetEffect(String ruleText) {
        this(ruleText, false);
    }

    public DestroyTargetEffect(boolean noRegen) {
        super(Outcome.DestroyPermanent);
        this.noRegen = noRegen;
    }

    public DestroyTargetEffect(String ruleText, boolean noRegen) {
        this(noRegen);
        this.staticText = ruleText;
    }

    protected DestroyTargetEffect(DestroyTargetEffect effect) {
        super(effect);
        this.noRegen = effect.noRegen;
    }

    @Override
    public DestroyTargetEffect copy() {
        return new DestroyTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int affectedTargets = 0;
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || !permanent.isPhasedIn()) continue;
            permanent.destroy(source, game, this.noRegen);
            ++affectedTargets;
        }
        return affectedTargets > 0;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder("destroy " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature"));
        if (this.noRegen) {
            sb.append(this.getTargetPointer().isPlural(mode.getTargets()) ? ". They" : ". It");
            sb.append(" can't be regenerated");
        }
        return sb.toString();
    }
}

