/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DetainAllRestrictionEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class DetainAllEffect
extends OneShotEffect {
    private FilterPermanent filter = new FilterPermanent();

    public DetainAllEffect(FilterPermanent filter) {
        super(Outcome.Benefit);
        this.filter = filter;
        this.staticText = "detain " + filter.getMessage();
    }

    protected DetainAllEffect(DetainAllEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public DetainAllEffect copy() {
        return new DetainAllEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        ArrayList<FixedTarget> detainedObjects = new ArrayList<FixedTarget>();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
            if (!game.isSimulation()) {
                game.informPlayers("Detained permanent: " + permanent.getName());
            }
            detainedObjects.add(new FixedTarget(permanent, game));
        }
        game.addEffect(new DetainAllRestrictionEffect(detainedObjects), source);
        return false;
    }
}

