/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class DoWhenCostPaid
extends OneShotEffect {
    private final ReflexiveTriggeredAbility ability;
    private final Cost cost;
    private final String chooseUseText;
    private final boolean optional;

    public DoWhenCostPaid(ReflexiveTriggeredAbility ability, Cost cost, String chooseUseText) {
        this(ability, cost, chooseUseText, true);
    }

    public DoWhenCostPaid(ReflexiveTriggeredAbility ability, Cost cost, String chooseUseText, boolean optional) {
        super(Outcome.Benefit);
        this.ability = ability;
        this.cost = cost;
        this.chooseUseText = chooseUseText;
        this.optional = optional;
    }

    private DoWhenCostPaid(DoWhenCostPaid effect) {
        super(effect);
        this.ability = effect.ability.copy();
        this.cost = effect.cost.copy();
        this.chooseUseText = effect.chooseUseText;
        this.optional = effect.optional;
    }

    private boolean checkOptional(Player player, Game game, Ability source) {
        return this.optional && !player.chooseUse(this.ability.getEffects().getOutcome(source, this.outcome), CardUtil.replaceSourceName(this.chooseUseText, CardUtil.getSourceName(game, source)), source, game);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (!this.cost.canPay(source, source, player.getId(), game) || this.checkOptional(player, game, source)) {
            return false;
        }
        this.cost.clearPaid();
        int bookmark = game.bookmarkState();
        if (this.cost.pay(source, game, source, player.getId(), false)) {
            if (this.ability.getTargets().isEmpty()) {
                this.ability.getEffects().setTargetPointer(this.getTargetPointer().copy());
            }
            game.fireReflexiveTriggeredAbility(this.ability, source);
            player.resetStoredBookmark(game);
            return true;
        }
        player.restoreState(bookmark, DoWhenCostPaid.class.getName(), game);
        return true;
    }

    public Cost getCost() {
        return this.cost;
    }

    @Override
    public String getText(Mode mode) {
        if (!this.staticText.isEmpty()) {
            return this.staticText;
        }
        return (this.optional ? "you may " : "") + CardUtil.addCostVerb(this.cost.getText()) + ". When you do, " + CardUtil.getTextWithFirstCharLowerCase(this.ability.getRule());
    }

    @Override
    public void setValue(String key, Object value) {
        super.setValue(key, value);
        this.ability.getEffects().setValue(key, value);
    }

    @Override
    public DoWhenCostPaid copy() {
        return new DoWhenCostPaid(this);
    }
}

