/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;

public class DontUntapInControllersNextUntapStepTargetEffect
extends ContinuousRuleModifyingEffectImpl {
    private UUID onlyIfControlledByPlayer;
    private String targetName;
    private boolean twoSteps;
    private final Map<UUID, Boolean> handledTargetsDuringTurn = new HashMap<UUID, Boolean>();

    public DontUntapInControllersNextUntapStepTargetEffect() {
        this("");
    }

    public DontUntapInControllersNextUntapStepTargetEffect(String targetName) {
        this(targetName, false, null);
    }

    public DontUntapInControllersNextUntapStepTargetEffect(String targetName, UUID onlyIfControlledByPlayer) {
        this(targetName, false, onlyIfControlledByPlayer);
    }

    public DontUntapInControllersNextUntapStepTargetEffect(String targetName, boolean twoSteps, UUID onlyIfControlledByPlayer) {
        super(Duration.Custom, Outcome.Detriment, false, true);
        this.targetName = targetName;
        this.twoSteps = twoSteps;
        this.onlyIfControlledByPlayer = onlyIfControlledByPlayer;
    }

    protected DontUntapInControllersNextUntapStepTargetEffect(DontUntapInControllersNextUntapStepTargetEffect effect) {
        super(effect);
        this.targetName = effect.targetName;
        this.twoSteps = effect.twoSteps;
        this.handledTargetsDuringTurn.putAll(effect.handledTargetsDuringTurn);
        this.onlyIfControlledByPlayer = effect.onlyIfControlledByPlayer;
    }

    @Override
    public DontUntapInControllersNextUntapStepTargetEffect copy() {
        return new DontUntapInControllersNextUntapStepTargetEffect(this);
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        Permanent permanentToUntap = game.getPermanent(event.getTargetId());
        if (permanentToUntap != null && mageObject != null) {
            return permanentToUntap.getLogName() + " doesn't untap (" + mageObject.getLogName() + ')';
        }
        return null;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP_STEP || event.getType() == GameEvent.EventType.UNTAP;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.UNTAP_STEP) {
            boolean allHandled = true;
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Permanent permanent2 = game.getPermanent(targetId);
                if (permanent2 == null) continue;
                if (game.isActivePlayer(permanent2.getControllerId()) && (this.onlyIfControlledByPlayer == null || game.isActivePlayer(this.onlyIfControlledByPlayer))) {
                    if (!this.handledTargetsDuringTurn.containsKey(targetId)) {
                        this.handledTargetsDuringTurn.put(targetId, false);
                        allHandled = false;
                        continue;
                    }
                    if (this.handledTargetsDuringTurn.get(targetId).booleanValue()) continue;
                    this.handledTargetsDuringTurn.put(targetId, !this.twoSteps);
                    continue;
                }
                allHandled = false;
            }
            if (allHandled) {
                this.discard();
            }
        }
        if (game.getTurnStepType() == PhaseStep.UNTAP && event.getType() == GameEvent.EventType.UNTAP && this.handledTargetsDuringTurn.containsKey(event.getTargetId()) && !this.handledTargetsDuringTurn.get(event.getTargetId()).booleanValue() && this.getTargetPointer().getTargets(game, source).contains(event.getTargetId()) && (permanent = game.getPermanent(event.getTargetId())) != null && game.isActivePlayer(permanent.getControllerId()) && (this.onlyIfControlledByPlayer == null || game.isActivePlayer(this.onlyIfControlledByPlayer))) {
            this.handledTargetsDuringTurn.put(event.getTargetId(), !this.twoSteps);
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        if (this.targetName != null && !this.targetName.isEmpty()) {
            if (this.targetName.equals("Those creatures") || this.targetName.equals("They")) {
                return this.targetName + " don't untap during their controller's next " + (this.twoSteps ? "two " : "") + "untap step" + (this.twoSteps ? "s" : "");
            }
            return this.targetName + " doesn't untap during its controller's next " + (this.twoSteps ? "two " : "") + "untap step" + (this.twoSteps ? "s" : "");
        }
        return "target " + (mode == null || mode.getTargets().isEmpty() ? "creature" : ((Target)mode.getTargets().get(0)).getTargetName()) + " doesn't untap during its controller's next " + (this.twoSteps ? "two " : "") + "untap step" + (this.twoSteps ? "s" : "");
    }
}

