/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.common.delayed.AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.EpicPushEffect;
import mage.abilities.effects.common.EpicReplacementEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

public class EpicEffect
extends OneShotEffect {
    private static final String rule = "Epic <i>(For the rest of the game, you can't cast spells. At the beginning of each of your upkeeps for the rest of the game, copy this spell except for its epic ability. If the spell has targets, you may choose new targets for the copy)</i>";

    public EpicEffect() {
        super(Outcome.Benefit);
        this.staticText = "<br>Epic <i>(For the rest of the game, you can't cast spells. At the beginning of each of your upkeeps for the rest of the game, copy this spell except for its epic ability. If the spell has targets, you may choose new targets for the copy)</i>";
    }

    private EpicEffect(EpicEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Spell spell = (Spell)source.getSourceObject(game);
        if (spell == null) {
            return false;
        }
        spell = spell.copy();
        spell.getSpellAbility().getEffects().removeIf(EpicEffect.class::isInstance);
        game.addDelayedTriggeredAbility(new AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility(new EpicPushEffect(spell, rule), Duration.EndOfGame, false), source);
        game.addEffect(new EpicReplacementEffect(), source);
        return true;
    }

    @Override
    public EpicEffect copy() {
        return new EpicEffect(this);
    }
}

