/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.MageSingleton;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AdventureCastFromExileEffect;
import mage.cards.AdventureCard;
import mage.cards.AdventureSpellCard;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class ExileAdventureSpellEffect
extends OneShotEffect
implements MageSingleton {
    private static final ExileAdventureSpellEffect instance = new ExileAdventureSpellEffect();

    public static ExileAdventureSpellEffect getInstance() {
        return instance;
    }

    public static UUID adventureExileId(UUID controllerId, Game game) {
        return CardUtil.getExileZoneId(controllerId.toString() + "- On an Adventure", game);
    }

    private ExileAdventureSpellEffect() {
        super(Outcome.Exile);
        this.staticText = "";
    }

    @Override
    public ExileAdventureSpellEffect copy() {
        return instance;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card spellCard;
            Spell spell = game.getStack().getSpell(source.getId());
            if (spell != null && (spellCard = spell.getCard()) instanceof AdventureSpellCard) {
                UUID exileId = ExileAdventureSpellEffect.adventureExileId(controller.getId(), game);
                game.getExile().createZone(exileId, "On an Adventure from " + controller.getName());
                AdventureSpellCard adventureSpellCard = (AdventureSpellCard)spellCard;
                AdventureCard parentCard = adventureSpellCard.getParentCard();
                if (controller.moveCardsToExile(parentCard, source, game, true, exileId, "On an Adventure from " + controller.getName())) {
                    AdventureCastFromExileEffect effect = new AdventureCastFromExileEffect();
                    effect.setTargetPointer(new FixedTarget(parentCard, game));
                    game.addEffect(effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

