/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class ExileAttachedEffect
extends OneShotEffect {
    public ExileAttachedEffect() {
        super(Outcome.Exile);
        this.staticText = "exile enchanted creature";
    }

    protected ExileAttachedEffect(ExileAttachedEffect effect) {
        super(effect);
    }

    @Override
    public ExileAttachedEffect copy() {
        return new ExileAttachedEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent creature;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (controller != null && enchantment != null && enchantment.getAttachedTo() != null && (creature = game.getPermanent(enchantment.getAttachedTo())) != null) {
            controller.moveCardsToExile(creature, source, game, true, null, "");
        }
        return false;
    }
}

