/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.MayLookAtTargetCardEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.CastManaAdjustment;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect
extends OneShotEffect {
    private final boolean useCastSpellOnly;
    private final CastManaAdjustment manaAdjustment;

    public ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect(boolean useCastSpellOnly, CastManaAdjustment manaAdjustment) {
        super(Outcome.Exile);
        switch (manaAdjustment) {
            case NONE: 
            case AS_THOUGH_ANY_MANA_TYPE: 
            case AS_THOUGH_ANY_MANA_COLOR: {
                this.manaAdjustment = manaAdjustment;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong code usage, manaAdjustment is not yet supported: " + (Object)((Object)manaAdjustment));
            }
        }
        this.useCastSpellOnly = useCastSpellOnly;
    }

    private ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect(ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect effect) {
        super(effect);
        this.manaAdjustment = effect.manaAdjustment;
        this.useCastSpellOnly = effect.useCastSpellOnly;
    }

    @Override
    public ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect copy() {
        return new ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        CardsImpl cards = new CardsImpl(this.getTargetPointer().getTargets(game, source).stream().map(game::getCard).filter(Objects::nonNull).collect(Collectors.toList()));
        if (controller == null || cards.isEmpty()) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId(game, source.getSourceId(), source.getStackMomentSourceZCC());
        MageObject sourceObject = source.getSourceObject(game);
        String exileName = sourceObject == null ? "" : sourceObject.getIdName();
        for (Card card : cards.getCards(game)) {
            card.setFaceDown(true, game);
            if (!controller.moveCardsToExile(card, source, game, false, exileZoneId, exileName)) continue;
            card.setFaceDown(true, game);
            switch (this.manaAdjustment) {
                case NONE: {
                    CardUtil.makeCardPlayable(game, source, card, this.useCastSpellOnly, Duration.Custom, false, controller.getId(), null);
                    break;
                }
                case AS_THOUGH_ANY_MANA_TYPE: 
                case AS_THOUGH_ANY_MANA_COLOR: {
                    CardUtil.makeCardPlayable(game, source, card, this.useCastSpellOnly, Duration.Custom, true, controller.getId(), null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong code usage, manaAdjustment is not yet supported: " + (Object)((Object)this.manaAdjustment));
                }
            }
            MayLookAtTargetCardEffect effect = new MayLookAtTargetCardEffect(controller.getId());
            effect.setTargetPointer(new FixedTarget(card.getId(), game));
            game.addEffect(effect, source);
        }
        return true;
    }
}

