/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

public class ExileGraveyardAllPlayersEffect
extends OneShotEffect {
    private final FilterCard filter;
    private final TargetController targetController;

    public ExileGraveyardAllPlayersEffect() {
        this(StaticFilters.FILTER_CARD_CARDS);
    }

    public ExileGraveyardAllPlayersEffect(FilterCard filter) {
        this(filter, TargetController.ANY);
    }

    public ExileGraveyardAllPlayersEffect(FilterCard filter, TargetController targetController) {
        super(Outcome.Exile);
        this.filter = filter;
        this.targetController = targetController;
        this.staticText = "exile all " + (filter.getMessage().equals("cards") ? "" : filter.getMessage() + " from all ") + (targetController.equals((Object)TargetController.OPPONENT) ? "opponents' " : "") + "graveyards";
    }

    protected ExileGraveyardAllPlayersEffect(ExileGraveyardAllPlayersEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.targetController = effect.targetController;
    }

    @Override
    public ExileGraveyardAllPlayersEffect copy() {
        return new ExileGraveyardAllPlayersEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl toExile = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player;
            if (TargetController.OPPONENT.equals((Object)this.targetController) && playerId.equals(source.getControllerId()) || (player = game.getPlayer(playerId)) == null) continue;
            toExile.addAllCards(player.getGraveyard().getCards(this.filter, source.getControllerId(), source, game));
        }
        controller.moveCards(toExile, Zone.EXILED, source, game);
        return true;
    }
}

