/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class ExileGraveyardAllTargetPlayerEffect
extends OneShotEffect {
    private final boolean toUniqueExile;

    public ExileGraveyardAllTargetPlayerEffect() {
        this(false);
    }

    public ExileGraveyardAllTargetPlayerEffect(boolean toUniqueExile) {
        super(Outcome.Exile);
        this.toUniqueExile = toUniqueExile;
    }

    private ExileGraveyardAllTargetPlayerEffect(ExileGraveyardAllTargetPlayerEffect effect) {
        super(effect);
        this.toUniqueExile = effect.toUniqueExile;
    }

    @Override
    public ExileGraveyardAllTargetPlayerEffect copy() {
        return new ExileGraveyardAllTargetPlayerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashSet<Card> cardsToExile = new HashSet<Card>();
        for (UUID playerId : this.getTargetPointer().getTargets(game, source)) {
            Player targetPlayer = game.getPlayer(playerId);
            if (targetPlayer == null) continue;
            cardsToExile.addAll(targetPlayer.getGraveyard().getCards(game));
        }
        return this.toUniqueExile ? controller.moveCardsToExile(cardsToExile, source, game, true, CardUtil.getExileZoneId(game, source), CardUtil.getSourceName(game, source)) : controller.moveCards(cardsToExile, Zone.EXILED, source, game);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder("exile ");
        sb.append(this.getTargetPointer().describeTargets(mode.getTargets(), "target player"));
        if (sb.toString().toLowerCase().endsWith("player") || sb.toString().toLowerCase().endsWith("opponent")) {
            if (this.getTargetPointer().isPlural(mode.getTargets())) {
                sb.append("s' graveyards");
            } else {
                sb.append("'s graveyard");
            }
        }
        return sb.toString();
    }
}

