/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class ExileSourceEffect
extends OneShotEffect {
    private final boolean toUniqueExileZone;

    public ExileSourceEffect() {
        this(false);
    }

    public ExileSourceEffect(boolean toUniqueExileZone) {
        super(Outcome.Exile);
        this.staticText = "exile {this}";
        this.toUniqueExileZone = toUniqueExileZone;
    }

    protected ExileSourceEffect(ExileSourceEffect effect) {
        super(effect);
        this.toUniqueExileZone = effect.toUniqueExileZone;
    }

    @Override
    public ExileSourceEffect copy() {
        return new ExileSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = source.getSourceCardIfItStillExists(game);
        if (controller == null || card == null) {
            return false;
        }
        if (card instanceof Permanent && !((Permanent)card).isPhasedIn()) {
            return false;
        }
        UUID exileZoneId = null;
        String exileZoneName = "";
        if (this.toUniqueExileZone) {
            exileZoneId = CardUtil.getExileZoneId(game, source.getSourceId(), source.getStackMomentSourceZCC());
            exileZoneName = card.getName();
        }
        return controller.moveCardsToExile(card, source, game, true, exileZoneId, exileZoneName);
    }
}

