/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.List;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.command.Emblem;

public class GetEmblemEffect
extends OneShotEffect {
    private final Emblem emblem;

    public GetEmblemEffect(Emblem emblem) {
        super(Outcome.Benefit);
        this.emblem = emblem;
        this.staticText = this.getText();
    }

    protected GetEmblemEffect(GetEmblemEffect effect) {
        super(effect);
        this.emblem = effect.emblem;
    }

    @Override
    public GetEmblemEffect copy() {
        return new GetEmblemEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject == null) {
            return false;
        }
        game.addEmblem(this.emblem, sourceObject, source);
        return true;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append("you get an emblem with \"");
        List<String> rules = this.emblem.getAbilities().getRules();
        sb.append(rules.get(0));
        if (rules.size() == 2) {
            sb.append("\" and \"");
            sb.append(rules.get(1));
        }
        sb.append('\"');
        return sb.toString();
    }
}

