/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class LookLibraryControllerEffect
extends OneShotEffect {
    protected DynamicValue numberOfCards;
    protected PutCards putLookedCards;
    protected boolean revealCards;

    public LookLibraryControllerEffect() {
        this(1);
    }

    public LookLibraryControllerEffect(int numberOfCards) {
        this(StaticValue.get(numberOfCards));
    }

    public LookLibraryControllerEffect(DynamicValue numberOfCards) {
        this(Outcome.Benefit, numberOfCards, PutCards.TOP_ANY);
    }

    public LookLibraryControllerEffect(Outcome outcome, DynamicValue numberOfCards, PutCards putLookedCards) {
        super(outcome);
        this.numberOfCards = numberOfCards;
        this.putLookedCards = putLookedCards;
        this.revealCards = false;
    }

    protected LookLibraryControllerEffect(LookLibraryControllerEffect effect) {
        super(effect);
        this.numberOfCards = effect.numberOfCards.copy();
        this.putLookedCards = effect.putLookedCards;
        this.revealCards = effect.revealCards;
    }

    @Override
    public LookLibraryControllerEffect copy() {
        return new LookLibraryControllerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        boolean topCardRevealed = controller.isTopCardRevealed();
        controller.setTopCardRevealed(false);
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, this.numberOfCards.calculate(game, source, this)));
        if (this.revealCards) {
            controller.revealCards(source, (Cards)cards, game);
        } else {
            controller.lookAtCards(source, null, cards, game);
        }
        boolean result = this.actionWithLookedCards(game, source, controller, cards);
        controller.setTopCardRevealed(topCardRevealed);
        return result;
    }

    protected boolean actionWithLookedCards(Game game, Ability source, Player player, Cards cards) {
        return this.putLookedCards.moveCards(player, cards, source, game);
    }

    @Override
    public String getText(Mode mode) {
        return this.setText(mode, "");
    }

    public String setText(Mode mode, String middleText) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String numberString = this.numberOfCards.toString();
        boolean dynamic = !this.numberOfCards.getMessage().isEmpty();
        boolean oneCard = !dynamic && numberString.equals("1");
        StringBuilder sb = new StringBuilder(this.revealCards ? "reveal " : "look at ");
        if (oneCard) {
            sb.append("the top card");
        } else if (dynamic) {
            sb.append("the top X cards");
        } else if (numberString.equals("that many")) {
            sb.append("that many cards from the top");
        } else {
            sb.append("the top ").append(CardUtil.numberToText(numberString)).append(" cards");
        }
        sb.append(" of your library");
        if (dynamic) {
            sb.append(", where X is ").append(this.numberOfCards.getMessage());
        }
        if (!middleText.isEmpty()) {
            sb.append(middleText);
        } else if (!oneCard) {
            sb.append(", then put them ");
            sb.append(this.putLookedCards == PutCards.TOP_ANY ? "back in any order" : this.putLookedCards.getMessage(false, true));
        }
        return sb.toString();
    }
}

