/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

public class LoseHalfLifeTargetEffect
extends OneShotEffect {
    public LoseHalfLifeTargetEffect() {
        super(Outcome.Damage);
    }

    protected LoseHalfLifeTargetEffect(LoseHalfLifeTargetEffect effect) {
        super(effect);
    }

    @Override
    public LoseHalfLifeTargetEffect copy() {
        return new LoseHalfLifeTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int amount;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && (amount = (int)Math.ceil((float)player.getLife() / 2.0f)) > 0) {
            player.loseLife(amount, game, source, false);
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "that player") + " loses half their life, rounded up";
    }
}

