/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.PlotAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

public class MayExileCardFromHandPlottedEffect
extends OneShotEffect {
    private final FilterCard filter;

    public MayExileCardFromHandPlottedEffect(FilterCard filter) {
        super(Outcome.PutCardInPlay);
        this.filter = filter;
        this.staticText = "you may exile a " + filter.getMessage() + " from your hand. If you do, it becomes plotted";
    }

    private MayExileCardFromHandPlottedEffect(MayExileCardFromHandPlottedEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public MayExileCardFromHandPlottedEffect copy() {
        return new MayExileCardFromHandPlottedEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, this.filter);
        if (player.chooseTarget(this.outcome, target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            PlotAbility.doExileAndPlotCard(card, game, source);
        }
        return true;
    }
}

