/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

public class OpponentsCantCastChosenUntilNextTurnEffect
extends ContinuousRuleModifyingEffectImpl {
    public OpponentsCantCastChosenUntilNextTurnEffect() {
        super(Duration.UntilYourNextTurn, Outcome.Benefit);
        this.staticText = "Until your next turn, your opponents can't cast spells with the chosen name";
    }

    protected OpponentsCantCastChosenUntilNextTurnEffect(OpponentsCantCastChosenUntilNextTurnEffect effect) {
        super(effect);
    }

    @Override
    public OpponentsCantCastChosenUntilNextTurnEffect copy() {
        return new OpponentsCantCastChosenUntilNextTurnEffect(this);
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (mageObject != null && cardName != null) {
            return "You can't cast a card named " + cardName + " (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        SpellAbility spellAbility = SpellAbility.getSpellAbilityFromEvent(event, game);
        if (spellAbility == null) {
            return false;
        }
        Card card = spellAbility.getCharacteristics(game);
        if (card == null) {
            return false;
        }
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        return CardUtil.haveSameNames(card, cardName, game);
    }
}

