/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterSource;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.TargetSource;

public class PreventAllDamageFromChosenSourceToYouEffect
extends PreventionEffectImpl {
    protected final TargetSource targetSource;

    public PreventAllDamageFromChosenSourceToYouEffect(Duration duration) {
        this(duration, new FilterSource());
    }

    public PreventAllDamageFromChosenSourceToYouEffect(Duration duration, FilterSource filter) {
        this(duration, filter, false);
    }

    public PreventAllDamageFromChosenSourceToYouEffect(Duration duration, FilterSource filter, boolean onlyCombat) {
        super(duration, Integer.MAX_VALUE, onlyCombat);
        this.targetSource = new TargetSource(filter);
        this.staticText = this.setText();
    }

    protected PreventAllDamageFromChosenSourceToYouEffect(PreventAllDamageFromChosenSourceToYouEffect effect) {
        super(effect);
        this.targetSource = effect.targetSource.copy();
    }

    @Override
    public PreventAllDamageFromChosenSourceToYouEffect copy() {
        return new PreventAllDamageFromChosenSourceToYouEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        this.targetSource.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
        if (this.targetSource.getFirstTarget() != null) {
            this.targetSource.updateTarget(this.targetSource.getFirstTarget(), game);
        }
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        this.preventDamageAction(event, source, game);
        return false;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(source.getControllerId()) && event.getSourceId().equals(this.targetSource.getFirstTarget()) && this.targetSource.isLegal(source, game);
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("Prevent all ");
        if (this.onlyCombat) {
            sb.append("combat ");
        }
        sb.append("damage that would be dealt to you ");
        if (this.duration == Duration.EndOfTurn) {
            sb.append("this turn ");
        }
        sb.append("by a ").append(this.targetSource.getFilter().getMessage());
        sb.append(" of your choice");
        return sb.toString();
    }
}

