/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.FilterPlayer;
import mage.filter.common.FilterPermanentOrPlayer;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.Copyable;

public class PreventAllDamageToAllEffect
extends PreventionEffectImpl {
    protected FilterPermanentOrPlayer filter;

    public PreventAllDamageToAllEffect(Duration duration, FilterPermanent filterPermanent) {
        this(duration, PreventAllDamageToAllEffect.createFilter(filterPermanent, null));
    }

    public PreventAllDamageToAllEffect(Duration duration, FilterPermanent filterPermanent, boolean onlyCombat) {
        this(duration, PreventAllDamageToAllEffect.createFilter(filterPermanent, null), onlyCombat);
    }

    public PreventAllDamageToAllEffect(Duration duration, FilterPermanentOrPlayer filter) {
        this(duration, filter, false);
    }

    public PreventAllDamageToAllEffect(Duration duration, FilterPermanentOrPlayer filter, boolean onlyCombat) {
        super(duration, Integer.MAX_VALUE, onlyCombat, false);
        this.filter = filter;
        this.staticText = "prevent all " + (onlyCombat ? "combat " : "") + "damage that would be dealt to " + filter.getMessage() + (duration.toString().isEmpty() ? "" : Character.valueOf(' ')) + (duration == Duration.EndOfTurn ? "this turn" : duration.toString());
    }

    protected PreventAllDamageToAllEffect(PreventAllDamageToAllEffect effect) {
        super(effect);
        this.filter = effect.filter.copy();
    }

    private static FilterPermanentOrPlayer createFilter(FilterPermanent filterPermanent, FilterPlayer filterPlayer) {
        FilterPlayer filter2;
        String mes1 = filterPermanent != null ? filterPermanent.getMessage() : "";
        String mes2 = filterPlayer != null ? filterPlayer.getMessage() : "";
        String message = !mes1.isEmpty() && !mes2.isEmpty() ? mes1 + " and " + mes2 : mes1 + mes2;
        FilterPermanent filter1 = filterPermanent;
        if (filter1 == null) {
            filter1 = new FilterPermanent();
            filter1.add(new PermanentIdPredicate(UUID.randomUUID()));
        }
        if ((filter2 = filterPlayer) == null) {
            filter2 = new FilterPlayer();
            filter2.add(new PlayerIdPredicate(UUID.randomUUID()));
        }
        return new FilterPermanentOrPlayer(message, filter1, filter2);
    }

    @Override
    public PreventAllDamageToAllEffect copy() {
        return new PreventAllDamageToAllEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Copyable<Player> object;
        if (super.applies(event, source, game) && (object = GameEvent.EventType.DAMAGE_PLAYER.equals((Object)event.getType()) ? game.getPlayer(event.getTargetId()) : game.getObject(event.getTargetId())) != null) {
            return this.filter.match((MageItem)((Object)object), source.getControllerId(), source, game);
        }
        return false;
    }
}

