/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class PreventAllDamageToAndByAttachedEffect
extends PreventionEffectImpl {
    private final String attachedDescription;

    public PreventAllDamageToAndByAttachedEffect(Duration duration, String attachedDescription, boolean onlyCombat) {
        super(duration, Integer.MAX_VALUE, onlyCombat);
        this.attachedDescription = attachedDescription;
        this.staticText = this.setText();
    }

    protected PreventAllDamageToAndByAttachedEffect(PreventAllDamageToAndByAttachedEffect effect) {
        super(effect);
        this.attachedDescription = effect.attachedDescription;
    }

    @Override
    public PreventAllDamageToAndByAttachedEffect copy() {
        return new PreventAllDamageToAndByAttachedEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent attachment;
        return super.applies(event, source, game) && (attachment = game.getPermanent(source.getSourceId())) != null && attachment.getAttachedTo() != null && (event.getTargetId().equals(attachment.getAttachedTo()) || event.getSourceId().equals(attachment.getAttachedTo()));
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("Prevent all ");
        if (this.onlyCombat) {
            sb.append("combat ");
        }
        sb.append("damage that would be dealt to and dealt by ");
        sb.append(this.attachedDescription);
        return sb.toString();
    }
}

