/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetSpell;

public class PreventDamageByTargetEffect
extends PreventionEffectImpl {
    private boolean passiveVoice = true;
    private boolean durationRuleAtEnd = true;

    public PreventDamageByTargetEffect(Duration duration, boolean onlyCombat) {
        this(duration, Integer.MAX_VALUE, onlyCombat);
    }

    public PreventDamageByTargetEffect(Duration duration, int amount, boolean onlyCombat) {
        super(duration, amount, onlyCombat);
    }

    protected PreventDamageByTargetEffect(PreventDamageByTargetEffect effect) {
        super(effect);
        this.passiveVoice = effect.passiveVoice;
        this.durationRuleAtEnd = effect.durationRuleAtEnd;
    }

    @Override
    public PreventDamageByTargetEffect copy() {
        return new PreventDamageByTargetEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used && super.applies(event, source, game)) {
            MageObject mageObject = game.getObject(event.getSourceId());
            if (mageObject != null && mageObject.isInstantOrSorcery(game)) {
                for (Target target : source.getTargets()) {
                    if (!(target instanceof TargetSpell) || !((TargetSpell)target).getSourceIds().contains(event.getSourceId())) continue;
                    return true;
                }
            }
            return this.getTargetPointer().getTargets(game, source).contains(event.getSourceId());
        }
        return false;
    }

    public PreventDamageByTargetEffect withTextOptions(boolean passiveVoice, boolean durationRuleAtEnd) {
        this.passiveVoice = passiveVoice;
        this.durationRuleAtEnd = durationRuleAtEnd;
        return this;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String durationText = this.duration == Duration.EndOfTurn ? " this turn" : ' ' + this.duration.toString();
        String targetText = this.getTargetPointer().describeTargets(mode.getTargets(), "it");
        String preventText = (this.amountToPrevent == Integer.MAX_VALUE ? "Prevent all" : "Prevent the next" + this.amountToPrevent) + (this.onlyCombat ? " combat damage " : " damage ");
        preventText = this.passiveVoice ? preventText + "that would be dealt" + (this.durationRuleAtEnd ? " by " + targetText + durationText : durationText + " by " + targetText) : preventText + targetText + " would deal" + durationText;
        return preventText;
    }
}

