/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.AttachmentType;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class PreventDamageToAttachedEffect
extends PreventionEffectImpl {
    protected AttachmentType attachmentType;

    public PreventDamageToAttachedEffect(Duration duration, AttachmentType attachmentType, boolean combatOnly) {
        this(duration, attachmentType, Integer.MAX_VALUE, combatOnly);
    }

    public PreventDamageToAttachedEffect(Duration duration, AttachmentType attachmentType, int amountToPrevent, boolean combatOnly) {
        super(duration, amountToPrevent, combatOnly, false);
        this.attachmentType = attachmentType;
        this.staticText = this.setText();
    }

    protected PreventDamageToAttachedEffect(PreventDamageToAttachedEffect effect) {
        super(effect);
        this.attachmentType = effect.attachmentType;
    }

    @Override
    public PreventDamageToAttachedEffect copy() {
        return new PreventDamageToAttachedEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent attachment;
        return super.applies(event, source, game) && (!this.onlyCombat || ((DamageEvent)event).isCombatDamage()) && (attachment = game.getPermanent(source.getSourceId())) != null && attachment.getAttachedTo() != null && event.getTargetId().equals(attachment.getAttachedTo());
    }

    private String setText() {
        StringBuilder sb = new StringBuilder();
        if (this.amountToPrevent == Integer.MAX_VALUE) {
            sb.append("prevent all ");
            if (this.onlyCombat) {
                sb.append("combat ");
            }
            sb.append("damage that would be dealt to ");
            sb.append(CardUtil.getTextWithFirstCharLowerCase(this.attachmentType.verb())).append(" creature");
        } else {
            sb.append("If a source would deal ");
            if (this.onlyCombat) {
                sb.append("combat ");
            }
            sb.append("damage to ");
            sb.append(CardUtil.getTextWithFirstCharLowerCase(this.attachmentType.verb()));
            sb.append(" creature, prevent ").append(this.amountToPrevent);
            sb.append(" of that damage");
        }
        return sb.toString();
    }
}

